//	PEcompare  -Compare if 2 PE is functional equal
//  LiuTaoTao 1998.9.19

//	Compile:	BCC32 pecompare.cpp

#include <stdio.h>
#include <mem.h>
//#include <windows.h>

#include "pe.h"

#define min(a,b)	(a>b? b:a)
typedef struct {
	BYTE	pos;
	BYTE	len;
	PSTR	name;
	}  STRU1;

void	comp_pehead();
void	comp_objtable();
void	errout();
void disp_dif(PSTR buf1,PSTR buf2,STRU1 *p,int n);
void cmp_obj(PSTR buf1,PSTR buf2);
void cmp_data(DWORD pos1,DWORD pos2,DWORD size);

FILE *fh1,*fh2;
PE pe1,pe2;
DWORD oPE1,psh1,oPE2,psh2;


void myRead1(PSTR buf,DWORD pos,DWORD len)
{
	fseek(fh1,pos,SEEK_SET);
	fread(buf,1,len,fh1);
}
DWORD Dread1(DWORD pos)
{
	DWORD d;
	myRead1(&d,pos,4);
	return d;
}
void myRead2(PSTR buf,DWORD pos,DWORD len)
{
	fseek(fh2,pos,SEEK_SET);
	fread(buf,1,len,fh2);
}
DWORD Dread2(DWORD pos)
{
	DWORD d;
	myRead2(&d,pos,4);
	return d;
}

void main(int argc,char **argv)
{

	printf("PEcompare by LiuTaoTao\n\n");

	if( argc<3 || *argv[1]== '/' ){
		printf("Usage: PEcompare <pe1.exe> <pe2.exe>");
		return;
		}

	fh1 = fopen( argv[1], "rb" );
	if( fh1==NULL ){
		printf("Can not open first file\n");
		return;
		}
	fh2 = fopen( argv[2], "rb" );
	if( fh2==NULL ){
		printf("Can not open second file\n");
		fclose(fh1);
		return;
		}

	oPE1 = Dread1(0x3c);
	if( Dread1(oPE1)!=0x4550 ){
		printf("PE1 Not a PE file!");
		errout();
		return;
		}
	oPE2 = Dread2(0x3c);
	if( Dread2(oPE2)!=0x4550 ){
		printf("PE2 Not a PE file!");
		errout();
		return;
		}

	myRead1(&pe1,oPE1,sizeof(PE));
	myRead2(&pe2,oPE2,sizeof(PE));

	//info();

	comp_pehead();

	psh1 =oPE1+24+pe1.SizeOfOptionalHeader;
	psh2 =oPE2+24+pe2.SizeOfOptionalHeader;
	

	comp_objtable();


	fclose(fh1);
	fclose(fh2);

}
void errout()
{
	fclose(fh1);
	fclose(fh2);
	printf("\7\n");
}

STRU1	peh[]={
    { 0x04, 2,   "Machine                "},
    { 0x06, 2,   "NumberOfSections       "},
    { 0x08, 4,   "TimeDateStamp          "},
    { 0x0c, 4,   "PointerToSymbolTable   "},
    { 0x10, 4,   "NumberOfSymbols        "},
    { 0x14, 2,   "SizeOfOptionalHeader   "},
    { 0x16, 2,   "Characteristics        "},
    { 0x18, 2,   "Magic                  "},
    { 0x1a, 2,   "LinkerVersion          "},
    { 0x1c, 4,   "SizeOfCode             "},
    { 0x20, 4,   "SizeOfInitializedData  "},
    { 0x24, 4,   "SizeOfUninitializedData"},
    { 0x28, 4,   "EntryPoint_RVA         "},
    { 0x2c, 4,   "BaseOfCode             "},
    { 0x30, 4,   "BaseOfData             "},
    { 0x34, 4,   "ImageBase              "},
    { 0x38, 4,   "SectionAlignment       "},
    { 0x3c, 4,   "FileAlignment          "},
    { 0x40, 4,   "OperatingSystemVersion "},
    { 0x44, 4,   "ImageVersion           "},
    { 0x48, 4,   "SubsystemVersion       "},
    { 0x4c, 4,   "Win32VersionValue      "},
    { 0x50, 4,   "SizeOfImage            "},
    { 0x54, 4,   "SizeOfHeaders          "},
    { 0x58, 4,   "CheckSum               "},
    { 0x5c, 2,   "Subsystem              "},
    { 0x5e, 2,   "DllCharacteristics     "},
    { 0x60, 4,   "SizeOfStackReserve     "},
    { 0x64, 4,   "SizeOfStackCommit      "},
    { 0x68, 4,   "SizeOfHeapReserve      "},
    { 0x6c, 4,   "SizeOfHeapCommit       "},
    { 0x70, 4,   "LoaderFlags            "},
    { 0x74, 4,   "NumberOfRvaAndSizes    "},
    { 0x78, 4,   "EXPORT_Table_RVA       "},
    { 0x7c, 4,   "EXPORT_Size            "},
    { 0x80, 4,   "IMPORT_Table_RVA       "},
    { 0x84, 4,   "IMPORT_Size            "},
    { 0x88, 4,   "RESORC_Table_RVA       "},
    { 0x8c, 4,   "RESORC_Size            "},
    { 0x90, 4,   "EXCEPT_Table_RVA       "},
    { 0x94, 4,   "EXCEPT_Size            "},
    { 0x98, 4,   "SECURT_Table_RVA       "},
    { 0x9c, 4,   "SECURT_Size            "},
	};

void	comp_pehead()
{
	if( !memcmp(&pe1,&pe2,sizeof(PE)))
		return;
	printf("PE head is diffrent\n\n");

	disp_dif((PSTR)&pe1,(PSTR)&pe2,peh,sizeof(peh)/sizeof(STRU1));
}
void	comp_objtable()
{
#define	nsec1	pe1.NumberOfSections
#define	nsec2	pe2.NumberOfSections
	char buf1[40],buf2[40];
	DWORD d1=psh1;
	DWORD d2=psh2;
	for(int i=0;i<nsec1 && i<nsec2;i++){
		myRead1(buf1,d1,40);
		myRead2(buf2,d2,40);

		char c=buf1[8];
		buf1[8] = 0;

		printf("\nsec %d    %s\n",i+1,buf1);
		buf1[8] = c;
		cmp_obj(buf1,buf2);
		d1 += 40;				//size
		d2 += 40;
		
		}
}
STRU1	obh[]={
    { 0x00, 8,   "Name                "},
    { 0x08, 4,   "VirtualSize         "},
    { 0x0c, 4,   "RVA                 "},
    { 0x10, 4,   "PhysicalSize        "},
    { 0x14, 4,   "PhysicalOffset      "},
    { 0x18, 4,   "PointerToRelocations"},
    { 0x1c, 4,   "PointerToLinenumbers"},
    { 0x20, 2,   "NumberOfRelocations "},
    { 0x22, 2,   "NumberOfLinenumbers "},
    { 0x24, 4,   "Object_Flags        "}
	};
//	prtl("VirtualSize RVA PhysicalSize PhysicalOffset");
/*
			27aa 1000 2800  400
			0069 4000 0200 2c00
			2264 5000 1000 2e00
			02b0 8000 0400 3e00
			0384 9000 0400 4200
*/

void cmp_obj(PSTR buf1,PSTR buf2)
{
	if( !memcmp(buf1,buf2,40)){
		char c=buf1[8];
		buf1[8]=0;
		printf("Section table %s is same\n",buf1);
		buf1[8]=c;
		}
	disp_dif(buf1,buf2,obh,sizeof(obh)/sizeof(STRU1));
	PObject_Table ps1=(PObject_Table)buf1;
	PObject_Table ps2=(PObject_Table)buf2;

	DWORD	siz1= min(ps1->VirtualSize,ps1->PhysicalSize);	//??
	DWORD	siz2= min(ps2->VirtualSize,ps2->PhysicalSize);	//??
	if( siz1 != siz2 )
		printf("\tSection Data size error\n");
	else
		cmp_data(ps1->PhysicalOffset, ps2->PhysicalOffset, siz1);
		
}
void disp_dif(PSTR buf1,PSTR buf2,STRU1 *p,int n)
{
	for(int i=0;i<n;i++){
		if( p[i].len == 2 ){	//word
			BYTE pos=p[i].pos;
			WORD w1= pw(buf1+pos);
			WORD w2= pw(buf2+pos);
			if( w1 != w2 )
				printf(" %s %x %x \t....error!\n",p[i].name,w1,w2);
			else
				printf(" %s %x \t....OK\n",p[i].name,w1);
			}
		if( p[i].len == 4 ){	//dword
			BYTE pos=p[i].pos;
			DWORD w1= pd(buf1+pos);
			DWORD w2= pd(buf2+pos);
			if( w1 != w2 )
				printf(" %s %x %x \t....error!\n",p[i].name,w1,w2);
			else
				printf(" %s %x \t....OK\n",p[i].name,w1);
			}
		if( p[i].len == 8 ){	//d dword
			PSTR p1= buf1+p[i].pos;
			PSTR p2= buf2+p[i].pos;
				char c1=p1[8];
				char c2=p2[8];
				p1[8] = 0;
				p2[8] = 0;
			if( pd(p1) != pd(p2) || pd(p1+4) != pd(p2+4) )
				printf(" %s %s %s \t....error!\n",p[i].name,p1,p2);
			else
				printf(" %s %s \t....OK\n",p[i].name,p1);

				p1[8] = c1;
				p2[8] = c2;
			}
		}
}
void cmp_data(DWORD pos1,DWORD pos2,DWORD size)
{
	char buf1[256],buf2[256];
	while( size>256 ){
		myRead1(buf1,pos1,256);
		myRead2(buf2,pos2,256);
		if( memcmp(buf1,buf2,256) ){
			printf("Section Data diffrent \t....error!\n");
			return;
			}
		pos1+=256;
		pos2+=256;
		size-=256;
		}
	myRead1(buf1,pos1,size);
	myRead2(buf2,pos2,size);
	if( memcmp(buf1,buf2,size) ){
		printf("Section Data diffrent \t....error!\n");
		}
}
