/* libvcs: C function library for screen control with /dev/vcsa* devices
 * Author: Adam Ierymenko [api@one.net]
 *
 * This library is free software; it may be copied freely and you may use
 * it in your programs as long as my name remains intact.  It comes with
 * absolutely no warranties. */

#ifndef LIBVCS_H

#include <stdio.h>

/* Handle structure */
struct vcs_handle {
	char device_filename[24];         /* Filename of device */
	int xsize,ysize;                  /* Size of screen */
	int foreground,background;        /* Colors */
	int xpos,ypos;                    /* Position on screen */
	int device_file;                  /* File handle used internally */
	unsigned char *scrbuf;            /* Buffer used internally */
};

/* Function prototypes */
extern struct vcs_handle *vcs_open(char *vcsname,char *ttyname);
extern void vcs_close(struct vcs_handle *vh);
extern int vcs_cls(struct vcs_handle *vh);
extern void vcs_setcolors(struct vcs_handle *vh,int foreground,int background);
extern int vcs_setpos(struct vcs_handle *vh,int xpos,int ypos);
extern int vcs_printf(struct vcs_handle *vh,unsigned char *format, ...);
extern int vcs_printchar(struct vcs_handle *vh,unsigned char wchar);
extern int vcs_setattr(struct vcs_handle *vh,int foreground,int background);
extern int vcs_clreol(struct vcs_handle *vh);
extern int vcs_scrollup(struct vcs_handle *vh);
extern int vcs_ansiprint(struct vcs_handle *vh,unsigned char *ansiblock,int delay);

/* Storage size of struct vcs_handle */
#define VCS_HANDLE_SIZE sizeof(struct vcs_handle)

/* Foreground colors */
#define FG_BLACK 0
#define FG_BLUE 1
#define FG_GREEN 2
#define FG_CYAN 3
#define FG_RED 4
#define FG_VIOLET 5
#define FG_MAGENTA 5
#define FG_BROWN 6
#define FG_YELLOW 6
#define FG_GREY 7             /* This is the normal terminal text color */
#define FG_DARKGREY 8     /* This can also just be added to the first 8 */
#define FG_LIGHTBLUE 9
#define FG_LIGHTGREEN 10
#define FG_LIGHTCYAN 11
#define FG_LIGHTRED 12
#define FG_LIGHTVIOLET 13
#define FG_LIGHTMAGENTA 13
#define FG_LIGHTYELLOW 14
#define FG_LIGHTBROWN 14
#define FG_WHITE 15
#define FG_BLINK 128          /* Add this to any of the above for blink */

/* Background colors */
#define BG_BLACK 0
#define BG_BLUE 16
#define BG_GREEN 32
#define BG_CYAN 48
#define BG_RED 64
#define BG_VIOLET 80
#define BG_MAGENTA 80
#define BG_BROWN 96
#define BG_YELLOW 96
#define BG_GREY 112
#define BG_WHITE BG_GREY

#endif
