#include "general.h"

/* general module source */

long freadblock( FILE *fp, long size, void *target ) {
	return fread( target, size, 1, fp );
}

void echo( void *source, long size ) {
	for( ; size>0; size-- ) {
		printf( "%03hu ", *(uchar *)source++ );
	}
}

int getkey() {
	struct termio zap, original;
	char c;
	int e;

	ioctl(fileno(stdin), TCGETA, &original);
	zap = original;

	zap.c_cc[VMIN] = 0;
	zap.c_cc[VTIME] = 0;
	zap.c_lflag = 0;

	ioctl(fileno(stdin), TCSETA, &zap);

	e = read(fileno(stdin), &c, 1);

	ioctl(fileno(stdin), TCSETA, &original);
	
	if (e == 0)
		return 0;

	return c;
}
