/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/***************************************************************************
                          midi_event.h  -  description
                             -------------------
    begin                : Mon Feb 4 2002
    copyright            : (C) 2002 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MIDI_CONTROL_H
#define MIDI_CONTROL_H


#include "midi_voice.h"
#include "mixer_base.h"
//#include "device_manager.h"
#include "midi_control_base.h"
#include <vector>
	using std::vector;


#include "engine_manager.h"
/**
  *@author Juan Linietsky
  */

#define PAN_LEFT 0
#define PAN_RIGHT 127
#define PAN_CENTER 64


class Midi_Control : public Midi_Control_Base {

public:
	Mixer_Base *mixer;
	Engine_Manager *engine_manager;
	void on_note_kill(int p_chan,int p_note);
private:

	enum {

		UNUSED_CTRL=-1
	};

	struct Channel {

		int patch;
		int bank;
		
		/* WARNING */
		/* I'm using a hashmap for simplicity. To avoid heap alocation (Bad for low latency?) */
		/* this should probably either become something else, or an stl allocator */
		/* must be written to get the pairs from a fixed pool */
		
		//typedef hash_map<int,Midi_Voice*> Voice_List;
		typedef vector<Midi_Voice*> Voice_List;
		

		Voice_List voice_list; //list of voices for this channel

		char default_custom_ctrl[128];

		/* TODO */
		/* handle the RPN/NRPN memory */

		int pitch_bender;
				
		void clear_controls() {

           		for (int i=0;i<128;i++) default_custom_ctrl[i]=UNUSED_CTRL;
		}

		Channel() {

			voice_list.resize(128);
			for (int i=0;i<128;i++)
				voice_list[i]=NULL;
			patch=0;
			bank=0;
           		clear_controls();
			pitch_bender=0x2000; // nothing.             
		};
	};


        int drums_channel;

	Channel channel[16]; //hardcoded 16 for now, this will change!

	void kill_chan_notes(char p_chan);

	int event_count;

  	void check_registered_parameter_number(int p_chan);
public:

	void set_drums_channel(int p_chan) { drums_channel=p_chan; }
	int get_drums_channel() { return drums_channel; }

	int get_chan_bank(int p_chan);
	int get_chan_patch(int p_chan);

        int get_event_count() { return event_count; }

	void note_on(char p_chan,char p_note,char p_velocity);
	void note_off(char p_chan,char p_note,char p_velocity);
	void controller(char p_chan,char p_ctrl,char p_param);
	void program_change(char p_chan,char p_program);
 	void pitch_bend(char p_chan,int p_val);



	Midi_Control();
	~Midi_Control();
};

#endif
