/***************************************************************************
    This file is part of the CheeseTronic Music Tools
    url                  : http://reduz.com.ar/cheesetronic
    copyright            : (C) 2003 by Juan Linietsky
    email                : coding@reduz.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef _RESAMPLER_H_
#define _RESAMPLER_H_

#include "sample_data.h"

/**
 * 
 * Juan Linietsky
 **/
class Resampler {
public:

	struct Mix_Data {
	
		int amount;
		sample_32s_t *dst_buff;			
		Sample_Data *sample;
		
		
		Sint64 sample_offset;
		Sint32 increment;
		Sint32 samples_to_mix;
		Uint8 fractional_size;

		Sint32 l_volume;
		Sint32 r_volume;
		//volume ramp data
		Sint32 l_volume_prev; 
		Sint32 r_volume_prev;

		struct Filter {
		
			bool enabled;
			Sint32 gain,coef1,coef2,hist1,hist2;
			
		} filter;
	};
	
	
	virtual void mix(Mix_Data *p_data)=0;
	
	
	virtual string get_name()=0;
	virtual bool has_interpolation()=0; //it's good to distingish them!
	

  Resampler();
  ~Resampler();
};

#endif
