
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsecontainer.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsecontainer.h>


#line 26 "bsecontainer.proc"


/* --- list-items --- */
static void
list_items_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 28 "bsecontainer.proc"
 {
#line 30 "bsecontainer.proc"
  *(in_pspecs++) = bse_param_spec_object ("container", NULL, NULL, BSE_TYPE_CONTAINER, SFI_PARAM_STANDARD);
  *(out_pspecs++) = bse_param_spec_boxed ("item_list", "Item List", NULL, BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD);
#line 32 "bsecontainer.proc"
}  }
static BseErrorType
#line 32 "bsecontainer.proc"
list_items_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 35 "bsecontainer.proc"
{
#line 36 "bsecontainer.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  
#line 39 "bsecontainer.proc"
  
  if (!BSE_IS_CONTAINER (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 43 "bsecontainer.proc"
  
  bse_value_take_boxed (out_values++, bse_container_list_items (container));
  
  return BSE_ERROR_NONE;
}

/* --- lookup-item --- */
static void
lookup_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 49 "bsecontainer.proc"
 {
#line 52 "bsecontainer.proc"
  *(in_pspecs++) = bse_param_spec_object ("container", "Container", "The Container", BSE_TYPE_CONTAINER, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("uname", "UName", "Unique item name", NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", "Item", "The item named by uname", BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 55 "bsecontainer.proc"
}  }
static BseErrorType
#line 55 "bsecontainer.proc"
lookup_item_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 58 "bsecontainer.proc"
{
#line 59 "bsecontainer.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  gchar *uname            = sfi_value_get_string (in_values++);
  
#line 63 "bsecontainer.proc"
  
  if (!BSE_IS_CONTAINER (container) || !uname)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 67 "bsecontainer.proc"
  
  bse_value_set_object (out_values++, bse_container_lookup_item (container, uname));
  
  return BSE_ERROR_NONE;
}

/* --- get-item --- */
static void
get_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 73 "bsecontainer.proc"
 {
#line 75 "bsecontainer.proc"
  *(in_pspecs++) = bse_param_spec_object ("container", NULL, NULL, BSE_TYPE_CONTAINER, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, "Type of the item to retrieve",
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("seq_id", NULL, "Sequential ID",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", NULL, "The item with seqid as requested", BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 81 "bsecontainer.proc"
}  }
static BseErrorType
#line 81 "bsecontainer.proc"
get_item_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 84 "bsecontainer.proc"
{
#line 85 "bsecontainer.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *type_name  = sfi_value_get_string (in_values++);
  guint seqid             = sfi_value_get_int (in_values++);
  GType type = type_name ? g_type_from_name (type_name) : 0;

#line 91 "bsecontainer.proc"
  
  if (!BSE_IS_CONTAINER (container) || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 95 "bsecontainer.proc"
  
  bse_value_set_object (out_values++, bse_container_get_item (container, type, seqid));

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static BseExportNodeProc __enode_list_items = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseContainer+list-items", 
    NULL,
    "/Methods/BseContainer/General/List Items",
    "Retrieve all items within a container",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, list_items_setup, list_items_exec, 
};
static BseExportNodeProc __enode_lookup_item = {
  { (BseExportNode*) &__enode_list_items, BSE_EXPORT_NODE_PROC,
    "BseContainer+lookup-item", 
    NULL,
    "/Methods/BseContainer/General/Lookup Item",
    ("Find an immediate child of a container from its uname (the uname "
	   "is the name of the item, unique between all immediate children of a container)."),
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, lookup_item_setup, lookup_item_exec, 
};
static BseExportNodeProc __enode_get_item = {
  { (BseExportNode*) &__enode_lookup_item, BSE_EXPORT_NODE_PROC,
    "BseContainer+get-item", 
    NULL,
    "/Methods/BseContainer/General/Get Item",
    "Retrieve a containers immediate child from it's sequential id.",
    "Tim Janik <timj@gtk.org>",
    "GNU Lesser General Public License",
  },
  0, get_item_setup, get_item_exec, 
};
BseExportNode* bse__builtin_init_bsecontainer_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsecontainer_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_get_item;
}

/**
 ** Generated data ends here
 **/
