/*
 * gcc modinfo.c -o modinfo
 * ./modinfo <PTK/STK file>
 * ----
 * June, the 13th of 2002.
 * (c) Sylvain "Asle" Chipaux
 * ----
 * July, the 4th of 2002 - update
 * - out file name is now "av[1]".txt
 * - fixed "unassigned value" warning at compilation
*/


#include "modinfo2.h"

void main ( int ac, char **av )
{
  FILE *in, *out;
  long i;
  unsigned char *DataFile, *outfilename;
  long poss[37];
  struct modHead modHead_ptr;
  struct sampleDescription smpDesc_ptr[31];
  struct modGeneral modGen;
  struct patStats pStats;

  poss[0] = 0;

  poss[1] = 0x358;
  poss[2] = 0x328;
  poss[3] = 0x2fa;
  poss[4] = 0x2d0;
  poss[5] = 0x2a6;
  poss[6] = 0x280;   /*  1  */
  poss[7] = 0x25c;
  poss[8] = 0x23a;
  poss[9] = 0x21a;
  poss[10] = 0x1fc;
  poss[11] = 0x1e0;
  poss[12] = 0x1c5;

  poss[13] = 0x1ac;
  poss[14] = 0x194;
  poss[15] = 0x17d;
  poss[16] = 0x168;
  poss[17] = 0x153;
  poss[18] = 0x140;   /*  2  */
  poss[19] = 0x12e;
  poss[20] = 0x11d;
  poss[21] = 0x10d;
  poss[22] = 0xfe;
  poss[23] = 0xf0;
  poss[24] = 0xe2;

  poss[25] = 0xd6;
  poss[26] = 0xca;
  poss[27] = 0xbe;
  poss[28] = 0xb4;
  poss[29] = 0xaa;
  poss[30] = 0xa0;   /*  3  */
  poss[31] = 0x97;
  poss[32] = 0x8f;
  poss[33] = 0x87;
  poss[34] = 0x7f;
  poss[35] = 0x78;
  poss[36] = 0x71;

  if ( ac != 2 )
  {
    synopsis ( av[0] );
    exit ( 1 );
  }
  if ( (in = fopen ( av[1], FOPEN_IN_ARG )) == NULL )
  {
    printf ( "cant find \"%s\" !\n", av[1] );
    synopsis ( av[0] );
    exit ( 2 );
  }
  outfilename = (unsigned char *) malloc (strlen(av[1]) + 4);
  sprintf ( outfilename, "%s.txt", av[1] );
  out = fopen ( outfilename , FOPEN_OUT_ARG );
  free ( outfilename );

  modGen.modSizeFile = returnFileSize ( in );
  DataFile = readFile ( in, modGen.modSizeFile );

  fprintf ( out, 
	    "generated by %s %s - 2002 (c) Sylvain \"Asle\" Chipaux\n"
	    "cmdline : \"%s %s\"\n----\n", VERSION, OS, av[0], av[1] );

  /* -------- */
  /* DataFile contains the whole input file */
  /* we have to determine wether we have a STK or a PTK */
  modGen.modHeadSize = returnSTKorPTK ( DataFile );
  /* let's fill-up these structs now */
  fillModHead ( &modHead_ptr, &modGen, DataFile );
  fillSmpDesc ( smpDesc_ptr, &modGen, DataFile );
  doAllTheStuffForThePatternList ( &modHead_ptr, &modGen );
  readPatternStuff ( &modGen, &pStats, DataFile, poss );

  /* write output */
  fprintf ( out, "TITLE : %s\n\n", modHead_ptr.modTitle );
  fprintf ( out, 
	    "WHOLE SAMPLE SIZE ..... : %ld\n"
	    "HEADER SIZE (HEAD+PAT). : %ld\n"
	    "FILE SIZE ............. : %ld\n"
	    "CALCULATED SIZE ....... : %ld\n\n"
	    , modGen.modWholeSampleSize
	    , modGen.modHeadSize + modGen.modNbrPatternStored*1024
	    , modGen.modSizeFile
	    , modGen.modHeadSize + modGen.modNbrPatternStored*1024 + modGen.modWholeSampleSize
	    );
  fprintf ( out, "\nNAME                     SIZE VOL FINE LSTART LSIZE   (Nbr times used)\n" );
  for ( i=0; i<((modGen.modHeadSize - 150)/30) ;i++ )
  {
    fprintf ( out, "%-23s", smpDesc_ptr[i].smpName );
    fprintf ( out, "%6d  ", smpDesc_ptr[i].smpSize );
    fprintf ( out, "%2d  ", smpDesc_ptr[i].smpVol );
    fprintf ( out, "%2d ", smpDesc_ptr[i].smpFine );
    fprintf ( out, "%6d ", smpDesc_ptr[i].smpLoopStart );
    fprintf ( out, "%6d", smpDesc_ptr[i].smpLoopSize );
    fprintf ( out, "         (%ld)\n", pStats.smp[i] );
  }
  fprintf ( out, "\n\nSIZE OF THE PATTERN LIST : %d\n", modHead_ptr.modPatternListSize);
  fprintf ( out, "\"NOISETRACKER BYTE\" : %d\n", modHead_ptr.modNTKByte);
  fprintfSpecialPatList ( &modHead_ptr, out );
  if ( modGen.modPatOuttaList != 0 )
  {
    fprintf ( out, "\nfollowing(s) pattern(s) is/are beside the pattern list :\n-> " );
    for ( i=0; i<modGen.modPatOuttaList; i++ )
      fprintf ( out, "%2d, ", modHead_ptr.modPatternList[modHead_ptr.modPatternListSize+i] );
    fprintf ( out, "\n" );
  }
  fprintf ( out, "\nNUMBER OF PATTERNS STORED : %ld\n", modGen.modNbrPatternStored );
  if ( modGen.modUnusedPatNbr != 0 )
  {
    fprintf ( out, "\nthere is/are %ld unused pattern(s) :\n-> ", modGen.modUnusedPatNbr );
    for ( i=0; i<modGen.modUnusedPatNbr; i++ )
      fprintf ( out, "%2d, ", modGen.modUnusedPatList[i] );
    fprintf ( out, "\n" );
  }
  fprintfSpecialFX ( &pStats, out );
  fprintfSpecialNotes ( &pStats, out );

  fclose ( out ), fclose ( in );
  free ( DataFile );
  exit ( 0 );
}
