// SetVideoMode() example, copyright (c) 1999 Street Raider // DDT Ent.
// ====================================================================
// Compiler: Watcom 10.0+
// Platform: DOS, VESA 1.2+

#include <string.h>
#include <stdio.h>
#include "dpmi.h"
#include "vesa.h"

#define VESA_LFB 0x4000
#define VESA_SUCCESS 0x004F

#define ALIGN(x, by_z) (((x) + (by_z - 1)) & ~(by_z - 1))

// sets mode with derived resolution and color depth (VESA 1.2+)
int SetDisplayMode(int Width, int Height, int bpp, int lfb = 0)
{
  DPMIRegs Regs;
  DosHandle Handle;
  ModeInfoBlock *ModeInfo;
  int ModeDepth;
  int VideoMode = 0;
  int n;

  // enumerate modes

  Handle = AllocDosMemory(sizeof(ModeInfoBlock) >> 4);
  ModeInfo = (ModeInfoBlock*) (DosHandle_Segment(Handle) << 4);

  for (n = 0x100; n < 0x400; n++)
  {
    memset(&Regs, 0, sizeof(DPMIRegs));
    Regs.ES = DosHandle_Segment(Handle);
    Regs.ECX = n;
    Regs.EAX = 0x4F01;
    RealModeInterrupt(0x10, &Regs);

    // check if mode exists
    if ((Regs.EAX & 0xFFFF) != 0x004F) continue;
    if ((ModeInfo->ModeAttributes & 1) == 0) continue;

    if (ModeInfo->MemoryModel == 4) ModeDepth = 8;
    else if (ModeInfo->MemoryModel == 6)
      ModeDepth = (ModeInfo->RedMaskSize + ModeInfo->GreenMaskSize +
        ModeInfo->BlueMaskSize + ModeInfo->RsvdMaskSize);
    else continue;

    if ((Width == ModeInfo->XResolution) &&
        (Height == ModeInfo->YResolution) &&
        (bpp == ModeDepth))
    {
      if (lfb && !((ModeInfo->ModeAttributes) & 0x80)) continue;

      VideoMode = lfb ? (n | VESA_LFB) : n;

      if (SetVesaMode(VideoMode) != VESA_SUCCESS)
      {
        VideoMode = 0;
        continue;
      }

      break; // break loop
    }
  }

  FreeDosMemory(Handle);

  return VideoMode;
}

extern void SetVideoMode(unsigned short int mode);
#pragma aux SetVideoMode = \
  "int 10h"        \
  parm [ax];

extern int ReadKey(void);
#pragma aux ReadKey = \
  "sub eax,eax"     \
  "int 16h"       \
  modify [eax] value [eax];

void main()
{
  // set hi-color mode
  if (!SetDisplayMode(640, 480, 16)) {
    printf("Can not set video mode :(\n");
    return;
  }

  // do the rest
  // ...

  ReadKey();

  SetVideoMode(0x03);
}
