
{ *** SBMULTI.PAS *** }
{ - modu miksuje prbki dwikowe na 4 kanay }

{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+,Y+}
{$M 16384,0,655360}
Unit SbMulti;

Interface
Uses unidsp, DOS;

Const
  maxinstr = 32;
  
Var
  { te zmienne mona odczytywa w czasie odtwarzania }
  { mog posuy do zrobienia efektu oscyloskopu }
  
  
  unitimer: Word;
  {licznik zmniejszany do zera co 1/18 sekundy}
  
  playbyte: Byte;
  { warto aktualnie odtwarzanej, zmiksowanej prbki }
  
  channelbyte: Array [0..3] Of Byte;
  { wartoci prbek w kadym z kanaw }
  
  
  { uruchomienie miksowania }
  { FREQ - czestotliwo miksowania w herzach
  (najlepiej <20000hz) }
Procedure MixerStart (freq: Word);

{ zakoczenie miksowania }
{ automatycznie wywoywana przy wyjciu z programu }
Procedure MixerStop;

{ wczytuje prbk z pliku }
{ format RAW 8-bit unsigned [ze znakiem] np. WAV }
{ F - plik }
{ N - numer prbki }
{ L - dugo w bajtach }
{ LOOP - zaptlanie }
{ POCZL - pocztek zaptlania }
{ ENDL - koniec zaptlania }
Procedure LoadSample (Var f: File; n: Byte; l: Word;
                                                                                        loop: Boolean; poczl, endl: Word);

{ tworzy prbk na podstawie podanej tablicy w pamici }
{ P - wskanik do tablicy z prbk }
{ pozostae parametry jak dla LoadSample }
Procedure MakeSample (p: pointer; n: Byte; l: Word;
                                                                                        loop: Boolean; poczl, endl: Word);

{ odtwarzanie prbki na "wirtualnym" kanale dwikowym }
{ CHAN - numer kanau (0-3) }
{ N - numer prbki }
{ FRQ - czstotliwo odtwarzania }
{ VOL - gono (0-64) }
{ OFSS - przesunicie pocztku odtwarzania }
Procedure PlaySample (chan, n: Byte; frq: Word;
                                                                                        vol: Byte; ofss: Word);

{ zwalnia pami przydzielona prbce }
{ N - numer prbki }
Procedure FreeSample (n: Byte);

{ zwalnia wszystkie prbki}
Procedure FreeAll;

{ zmienia czstotliwo odtwarzania w czasie jego trwania}
{ CHAN - kana dwiku }
{ FRQ - nowa czstotliwo }
Procedure AdjustChannelFreq (chan: Byte; frq: Word);

{ zwraca czstotliwo odtwarzania dwiku w kanale }
{ CHAN - kana dwieku }
{ powrt: czstotliwo }
Function GetChannelFreq (chan: Byte): Word;



Implementation


Const
{offsety pl w typie tchannel}
  asq = 0;
  ale = 4;
  afreq = 6;
  apoczlop = 8;
  aendlop = 10;
  aloop = 12;
  aplay = 13;
  aposc = 14;
  aposp = 16;
  aaddc = 18;
  aaddp = 20;
  avoldiv = 22;

Type
  tchannel = Record
               sq: pointer;  {wskanik do sampla}
               le: Word;  {dugo sampla}
               freq: Word;  {czstotliwo}
               poczlop, endlop: Word;  {zaptlenie}
               loop: Boolean;
               play: Boolean;  {czy aktywny?}
               posc, posp: Word;  {uamek -> pozycja}
               addc, addp: Word;  {uamek -> delta}
               voldiv: Byte;  {podzielnik gonoci}
               insnum: Byte;  {numer instrumentu}
             End;
  tinstr = Record
             st: pointer;   {wskanik do prbki}
             le: Word;  {dugo}
             poczlop, endlop: Word;  {zaptlenie}
             loop: Boolean;
           End;

Var
  mixfreq: Word;    {czstotl. miksowania}
  old_8h: pointer;  {stare INT 8h}
  licz, liczstd: Word;  {licznik INT 8h}
  mix: Array [0..3] Of tchannel;  {kanay}
  itab: Array [1..maxinstr] Of tinstr;  {instrumenty}
  speakplay: Boolean;  {czy trwa miksowanie?}



Function GetChannelFreq;
Begin
  GetChannelFreq := mix [chan].freq;
End;


Procedure FreeSample;
Begin
  With itab [n] Do Begin
    If le <> 0 Then Begin
      FreeMem (st, le);
      le := 0;
    End;
  End;
End;


Procedure FreeAll;
Var
  i: Byte;
Begin
  For i := 0 To 3 Do mix [i].play := False;
  For i := 1 To maxinstr Do FreeSample (i);
End;


Procedure MakeSample;
Begin
  itab [n].st := p;
  itab [n].le := l;
  itab [n].loop := loop;
  itab [n].poczlop := poczl;
  itab [n].endlop := endl;
End;


Procedure LoadSample;
Begin
  FreeSample (n);
  GetMem (itab [n].st, l);
  itab [n].le := l;
  BlockRead (f, itab [n].st^, l);
  itab [n].loop := loop;
  itab [n].poczlop := poczl;
  itab [n].endlop := endl;
End;


Procedure PlaySample;
Var podz: Real;
Begin
  If (n < 1) Or (n > maxinstr) Then Exit;
  With mix [chan] Do Begin
    If itab [n].le <> 0 Then Begin
      insnum := n;
      sq := itab [n].st;
      freq := frq;
      loop := itab [n].loop;
      podz := freq / mixfreq;
      le := itab [n].le;
      poczlop := itab [n].poczlop;
      endlop := itab [n].endlop;
      
      posc := ofss;
      posp := 0;
      addc := Round (Int (podz) );
      addp := Round (100 * Frac (podz) );
      
      If vol = 0 Then voldiv := 0 Else
        voldiv := 64 Div vol;
      play := True;
    End;
  End;
End;


Procedure AdjustChannelFreq;
Var podz: Real;
Begin
  With mix [chan] Do Begin
    freq := frq;
    podz := freq / mixfreq;
    addc := Round (Int (podz) );
    addp := Round (100 * Frac (podz) );
  End;
End;


Procedure PlayerInt; Interrupt;
Var
  psam, i: Integer;
  boff: Array [0..3] Of Word;
Begin
  For i := 0 To 3 Do boff [i] := Ofs (mix [i] );
  Asm
    mov     psam, 0
    mov     i, 0
    @loopi:          {ptla miksowania kanaw}
    mov     SI, i
    ShL     SI, 1
    mov     DI, Word Ptr boff + SI
    cmp     Byte Ptr [DI + aplay], True {czy ten aktywny?}
    jne     @notplay
    mov     AX, [DI + asq + 2]
    mov     ES, AX
    mov     BX, [DI + asq]
    mov     SI, [DI + aposc]
    mov     AL, ES: [BX + SI] {prbka do AL}
    add     AL, 128   { zamiana na bajty ze znakiem}
    Not     AL
    @D1:
    mov     BL, [DI + avoldiv]
    cmp     BL, 0     {czy cisza?}
    je      @null
    cbw
    cmp     BL, 1     {czy potrzebne dzielenie?}
    je       @niedzielic
    idiv    BL     {niestety, trzeba dzieli}
    @niedzielic:
    jmp     @dalej0
    @null:
    mov     AL, 128   {cisza na kanale}
    @dalej0:
    mov     BX, Offset [channelbyte]
    mov     SI, [i]
    mov     [BX + SI], AL  {warto prbki do tablicy}
    cbw
    add     [psam], AX    {psam - miksowana prbka}
    mov     AX, [DI + aaddc]
    add     [DI + aposc], AX  {dodajemy cz cakowit}
    mov     AX, [DI + aaddp]
    mov     BX, [DI + aposp]
    add     BX, AX            {i cz po przecinku}
    cmp     BX, 100      {czy cz po przecinku wiksza}
    jb      @D2              {od 100}
    Inc     Word Ptr [DI + aposc]   {tak -> jedna dalej}
    sub     BX, 100           {zabieramy te 100}
    @D2:
    mov     [DI + aposp], BX
    mov     AL, [DI + aloop]
    cmp     AL, False
    je      @D3
    mov     AX, [DI + aposc]    {ta czesc realizuje ptle}
    cmp     AX, [DI + aendlop]
    jb      @D3
    mov     AX, [DI + apoczlop]
    mov     [DI + aposc], AX
    @D3:
    mov     AX, [DI + aposc]
    cmp     AX, [DI + ale]
    jb      @notplay
    mov     AL, False             {koniec odtwarzania}
    mov     [DI + aplay], AL
    @notplay:
    Inc     i
    cmp     i, 4
    jne     @loopi

    mov     AX, psam
    sar     AX, 2       {rednia arytmetyczna}
    add     AX, 128     {na liczb bez znaku}
    mov     AH, 0
    mov     playbyte, AL
    push    AX
    Call    sendsample   {wysanie bajtu do portu}
    mov     AX, [licz]
    Dec     AX
    Or      AX, AX
    jnz     @dalej
    mov     AX, [liczstd]
    pushf
    Call    old_8h     {stare przerwanie 18.2 razy na s.}
    mov     BX, [unitimer]
    Or      BX, BX
    jz       @dalej
    Dec      BX
    mov       [unitimer], BX   {prywatny licznik}
    @dalej:
    mov       [licz], AX
    mov     AL, 20h
    out     20h, AL
  End;
End;


Procedure MixerStop;
Begin
  If speakplay = False Then Exit;
  speakplay := False;
  port [$21] := port [$21] Or 1;
  port [$43] := $36;
  port [$40] := 0;
  port [$40] := 0;
  SetIntVec ($8, old_8h);
  port [$21] := port [$21] And $fe;
End;


Procedure MixerStart;
Begin
  mixfreq := freq;
  initializedsp;
  mixerstop;
  speakplay := True;
  liczstd := mixfreq Div 18;
  licz := liczstd;
  port [$21] := port [$21] Or 1;
  GetIntVec ($8, old_8h);
  SetIntVec ($8, @playerint);
  port [$43] := $36;
  port [$40] := Lo (1193180 Div mixfreq);
  port [$40] := Hi (1193180 Div mixfreq);
  port [$21] := port [$21] And $fe;
End;


Var
  i: Byte;
  oldexit: pointer;
  
Procedure newexit; Far;
Begin
  mixerstop;
  ExitProc := oldexit;
End;


Begin
  speakplay := False;
  For i := 1 To maxinstr Do itab [i].le := 0;
  For i := 0 To 3 Do mix [i].play := False;
  oldexit := ExitProc;
  ExitProc := @newexit;
End.
