		ideal
		p386
		model	large,pascal

		codeseg

; -- init_shadebob ---------------------------------------------
;
@dgroup	dw	DGROUP
		dataseg
def_bob_traect	dd	0
NBOBROWS	=	16
NBOBCOLS	=	16
label		original_bob	byte
db	0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0
db	0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0
db	0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0
db	0,0,1,1,1,1,1,2,2,1,1,1,1,1,0,0
db	0,1,1,1,1,2,2,2,2,2,2,1,1,1,1,0
db	0,1,1,1,2,2,2,3,3,2,2,2,1,1,1,0
db	1,1,1,2,2,2,3,3,3,3,2,2,2,1,1,1
db	1,1,2,2,2,3,3,4,4,3,3,2,2,2,1,1
db	1,1,2,2,2,3,3,4,4,3,3,2,2,2,1,1
db	1,1,1,2,2,2,3,3,3,3,2,2,2,1,1,1
db	0,1,1,1,2,2,2,3,3,2,2,2,1,1,1,0
db	0,1,1,1,1,2,2,2,2,2,2,1,1,1,1,0
db	0,0,1,1,1,1,1,2,2,1,1,1,1,1,0,0
db	0,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0
db	0,0,0,0,1,1,1,1,1,1,1,1,0,0,0,0
db	0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0
		udataseg
label		scaled_bob	byte
db	NBOBROWS*NBOBCOLS dup(?)
label		compiled_bob	byte
db	NBOBROWS*(NBOBCOLS+2) dup(?)
		codeseg
public		init_shadebob
proc		init_shadebob	far
	pushad
	push	ds es
	mov	dx,ax
	mov	ax,[@dgroup]
	mov	ds,ax
	mov	es,ax
	xor	eax,eax
	mov	[def_bob_traect],eax
	call	scale_shadebob
	mov	si,offset scaled_bob
	call	compile_shadebob
	pop	es ds
	popad
	ret
endp		init_shadebob
; -- scale_shadebob --------------------------------------------
;
proc		scale_shadebob	near
	mov	si,offset original_bob
	push	si
	mov	cx,NBOBROWS*NBOBCOLS
	mov	bl,0
@@loop0:
	lodsb
	cmp	al,bl
	jbe	@@1
	mov	bl,al
@@1:
	loop	@@loop0
	pop	si
	cmp	dl,1
	adc	dl,-1
	mov	di,offset scaled_bob
	mov	cx,NBOBROWS*NBOBCOLS
@@loop1:
	lodsb
	mul	dl
	div	bl
	stosb
	loop	@@loop1
	ret
endp		scale_shadebob

; -- compile_shadebob ------------------------------------------
;
proc		compile_shadebob	near
	pushad
	push	es
	mov	es,[@dgroup]
	mov	di,offset compiled_bob
	mov	bp,NBOBROWS
@@compile:
	mov	cx,NBOBCOLS
	xor	dx,dx
@@skip:
	lodsb
	or	al,al
	jnz	@@nonzero0
	inc	dx
	loop	@@skip
	mov	[es:di],dl
	inc	di
	stosb	; Zero body
	stosb	; Zero tail
	jmp	@@next
@@nonzero0:
	mov	[es:di],dl	; Head length
	add	di,2
	lea	bx,[di-1]
	stosb
	mov	dx,1	; Body has length at least 1
	dec	cx
	jz	@@count_tail
@@count_body:
	lodsb
	or	al,al
	jz	@@count_tail
	stosb
	inc	dx
	loop	@@count_body
@@count_tail:
	mov	[es:bx],dl	; Length of body
	mov	[es:di],cl	; Remaining bytes are all zero
	inc	di
	add	si,cx
	cmp	cx,1
	adc	si,-1
@@next:
	dec	bp
	jnz	@@compile
	pop	es
	popad
	ret
endp		compile_shadebob

; -- set_bob_traectory -----------------------------------------
;
public		set_bob_traectory
proc		set_bob_traectory	far
	push	ds
	mov	ds,[@dgroup]
	mov	[word def_bob_traect],ax
	mov	[word def_bob_traect+2],dx
	pop	ds
	ret
endp		set_bob_traectory

; -- put_shadebob ----------------------------------------------
; No screen bounds checking
public		put_shadebob
proc		put_shadebob	far
	pushad
	mov	bp,[word def_bob_traect]
	or	bp,[word def_bob_traect+2]
	jz	@@end
	call	[def_bob_traect]
	jc	@@end
	push	ds es
	mov	cx,0a000h
	mov	es,cx
	mov	ds,[@dgroup]
	imul	di,bx,320
	add	di,ax
	mov	bp,NBOBROWS
	mov	si,offset compiled_bob
@@loop:
	lea	bx,[di+320]
	movzx	ax,[byte si]
	add	di,ax
	movzx	cx,[byte si+1]
	add	si,2
	mov	dx,2
IF	1	; If straight copy
	shr	cx,1
	rep	movsw
	adc	cl,cl
	rep	movsb
ELSE	; Add copy
	test	cl,1
	jz	@@shift
	lodsb
	add	[es:di],al
	inc	di
@@shift:
	shr	cx,1
	jz	@@next
@@addloop:
	mov	ax,[si]
	add	si,dx
IF	0
	add	[es:di],al
	add	[es:di+1],ah
ELSE
	add	al,[es:di]
jnc	@@_1
int 3
@@_1:
	add	ah,[es:di+1]
jnc	@@_2
int 3
@@_2:
	mov	[es:di],ax
ENDIF
	add	di,dx
	loop	@@addloop
ENDIF
@@next:
	inc	si
	mov	di,bx
	dec	bp
	jnz	@@loop
	pop	es ds
@@end:
	popad
	ret
endp		put_shadebob

		end
