{*
 * (C)1999 by Brian Zhou.  All rights reserved.
 * Mystic Origin Line Changer v001 for MysticBBS v1.04b
 *
 * Made by request of sloop.
 *}

program molc;

type
  MBaseRec = Record                    { MBASES.DAT                       }
    Name     : String[40];             { Message base name                }
    QWKName  : String[13];             { QWK (short) message base name    }
    FileName : String[8];              { Message base file name           }
    Path     : String[40];             { Path where files are stored      }
    BaseType : Byte;                   { 0 = JAM    1 = SQUISH            }
    NetType  : Byte;                   { 0 = Local  1 = FIDO   2 = UseNet }
    PostType : Byte;                   { 0 = Public 1 = Private           }
    ACS,                               { ACS required to see this base    }
    ReadACS,                           { ACS required to read messages    }
    PostACS,                           { ACS required to post messages    }
    SysopACS : String[20];             { ACS required for sysop options   }
    Password : String[15];             { Password for this message base   }
    ColQuote : Byte;                   { Quote text color                 }
    ColText  : Byte;                   { Text color                       }
    ColTear  : Byte;                   { Tear line color                  }
    ColOrigin: Byte;                   { Origin line color                }
    NetAddr  : Byte;                   { Net AKA to use for this base     }
    Origin   : String[50];             { Net origin line for this base    }
    UseReal  : Boolean;                { Use real names?                  }
    DefNScan : Boolean;                { Default New Scan Setting         }
    DefQScan : Boolean;                { Default QWK scan setting         }
    MaxMsgs  : Word;                   { Max messages to allow            }
    MaxAge   : Word;                   { Max age of messages before purge }
    Header   : String[8];              { Display Header file name         }
    Index    : Integer;                { QWK index - NEVER CHANGE THIS    }
  End;

var
  r:mbaserec;
  f:file of mbaserec;
  s:string;

begin
  writeln('Mystic Origin Line Changer v001 by Brian Zhou');
  writeln('(C)1999 by Brian Zhou.   All rights reserved.');
  writeln('---------------------------------------------');
  writeln('Changes all the origin lines in MBASES.DAT.');
  writeln('Run this in your /DATA directory.');
  writeln;
  assign(f,'mbases.dat');
  {$I-} reset(F); {$I+}
  If IOResult <> 0 Then Begin
    WriteLn('MBASES.DAT not found in current directory!  Aborting!');
    Halt;
  End;
  WriteLn('New origin line (50 chars) ----------------------|');
  write(':'); readln(s);
  repeat
  {$I-}
    read(f, r);
    r.origin := s;
    seek(f, filepos(F)-1);
    write(f,r);
    {$I+}
  until ioresult<>0;
  close(F);
end.
