#include <dos.h>
#include <i86.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <graph.h>
#include <bios.h>
#include <string.h>
#include <malloc.h>
#include <time.h>

#if !defined(pi)
  #define pi 3.1415927
#endif

#define vga 0xa0000

  typedef unsigned char  byte;
  typedef unsigned short word;
  typedef unsigned long  dword;

byte far *VirtPtr;
dword vaddr;
/*byte virt[64000];*/
char pall[256][3];
char pall2[256][3];

/*void __far *_fmalloc(size_t size);
void _free (void __far *ptr);*/
void cls (dword where, unsigned char col);
void flip(dword source, dword dest);
void waitretrace();
void setmcga();
void pal(unsigned char Col, unsigned char R, unsigned char G,
        unsigned char B);
void settext();
void putpixel(word x, word y, byte col,dword where);
void setupvirtual();
void setupvirtual2();
void shutdown();
int round(float x);
float rad(word theta);
void getpal(char ColorNo, char* R, char* G, char* B);
void grabpallette();
void restorepallette();
void line(int x1, int y1, int x2, int y2, unsigned char Color);




void cls (dword where, unsigned char col)
{
  #pragma aux cls = \
    "mov  ah,al"    \
    "mov  dx,ax"    \
    "shl  eax,16"   \
    "mov  ax,dx"    \
    "mov  cx,16000" \
    "rep  stosd"    \ 
    modify[ecx edx] \
    parm[edi][eax];
}
/*may need a mov edi,vga */

void flip(dword source, dword dest)
{
  #pragma aux flip =   \
  "mov ecx,16000"      \
  "mov eax,esi"        \
  "rep movsd"          \
  modify[ecx]          \
  parm[esi][edi];
}


void waitretrace()
{
  #pragma aux waitretrace = \
    "mov dx,3DAh" \
"l1:            " \
    "in al,dx   " \
    "and al,08h " \
    "jnz l1     " \
"l2:            " \
    "in al,dx   " \
    "and al,08h " \
   "jz  l2      " \
   modify[ax dx];  
}


void setmcga()
{
 #pragma aux setmcga = \
    "mov  eax,13h"     \
    "int  10h    "     \
    modify [eax];
}

void pal(unsigned char Col, unsigned char R, unsigned char G,
        unsigned char B)
{
  outp (0x03C8,Col); 
  outp (0x03C9,R);
  outp (0x03C9,G);
  outp (0x03C9,B);

}

void settext()
{
 #pragma aux settext =  \
    "mov  eax,3h"       \
    "int  10h   "       \
    modify [eax];
}

void putpixel(word x, word y, byte col,dword where)
{
 #pragma aux putpixel = \
    "mov  ebx,edx"      \
    "shl  edx,8"        \        
    "add  edi,ecx"      \
    "shl  ebx,6"        \        
    "add  edi,edx"      \        
    "add  edi,ebx"      \
    "mov  BYTE PTR [edi],al"     \
    modify [ebx]        \
    parm  [ecx][edx][al][edi];
}
void setupvirtual()
{
/*   VirtPtr=&Virtual[0]; */
   VirtPtr=(byte far *) malloc(64000);  
   vaddr = FP_OFF(VirtPtr);  
}
void setupvirtual2()
{
/*   VirtPtr=virt; 
   vaddr = FP_OFF(VirtPtr);  */
}

 void shutdown()
{
/*  _ffree(VirtPtr);*/
}  

int round(float x)
{
  if(x>=0)
    return (int)(x+0.5);
  else
    return (int)(x-0.5);
}

float rad(word theta)
{
  return (((theta * pi)/180));
}

void getpal(char ColorNo, char* R, char* G, char* B)
{
   outp(0x3c7,ColorNo);
   *R=inp(0x3c9);
   *G=inp(0x3c9);
   *B=inp(0x3c9);
}

void grabpallette()
{
  int loop1;
  for(loop1=0;loop1<256;loop1++)
  {
    getpal((unsigned char)loop1,&pall2[loop1][0],&pall2[loop1][1],&pall2[loop1][2]);
  }
}

void restorepallette()
{
  int loop1;
  waitretrace();
  for(loop1=0;loop1<256;loop1++)
    pal ((unsigned char)loop1,pall2[loop1][0],pall2[loop1][1],pall2[loop1][2]);
}

void line(int x1, int y1, int x2, int y2, unsigned char Color, dword where)

{
  int dx,dy,incr1,incr2,d,x,y,xend,yend,yinc,xinc;

  dx=abs(x2-x1);
  dy=abs(y2-y1);

  if(dx>=dy) // slope < 1
  {
    if(x1>x2)
	{
	  x=x2; y=y2; xend=x1;
	  if(dy==0) yinc=0;
	  else { if(y2>y1) yinc=-1; else yinc=1;}
	}
	else
	{
	  x=x1; y=y1; xend=x2;
	  if(dy==0) yinc=0;
	  else { if(y2>y1) yinc=1; else yinc=-1;}
	}
    incr1=2*dy; d=incr1-dx; incr2=2*(dy-dx);
        putpixel(x,y,Color,where);
    while(x<xend)
    {
      x++;
      if(d<0) d+=incr1;
      else { y+=yinc; d+=incr2;}
          putpixel(x,y,Color,where);
    }
  }
  else
  {
    if(y1>y2)
	{ 
	  x=x2; y=y2; yend=y1;
	  if(dx==0) xinc=0;
	  else { if(x2>x1) xinc = -1; else xinc = 1;}
    }
	else
	{
	  x=x1; y=y1; yend=y2;
	  if(dx==0) xinc=0;
	  else { if(x2>x1) xinc=1; else xinc = -1;}
	}
	incr1=2*dx; d=incr1-dy; incr2=2*(dx-dy);
        putpixel(x,y,Color,where);
	while(y<yend)
	{
	  y++;
	  if(d<0) d+=incr1;
	  else { x+=xinc; d+=incr2; }
          putpixel(x,y,Color,where);
	}
  }
}
