Program ShadeQixss;

uses bgl,crt;

(*

Discription:

As per the Qix type screen saver (delayed lines bouncing around the screen)
This SS will add to that idea by changing the concept of how the colors are
plotted.  Instead of drawing/undrawing a specific line, this program will
increase/decrease the colors on the screen.

*)

Type
 linesT = record points: array[1..2] of pointo; end;

const
 maxlines = 1024;
 ourx : word = 320;
 oury : word = 200;

Var
 Mylines: array[1..maxlines] of linesT;
 templine:linest;
 temp :integer;
 xmove,ymove:array[1..2] of integer;
 thesecolors:allcolors;
 mynumlines,thispallet,i:integer;
 cyclecolors:boolean;
 tempstr : string;
 vidmode : integer;
 maxmove: integer;
 ptr : integer;
 key:char;

{---------------------------------------------------}

(* first, the line draw/erase stuff *)

procedure dolineasm(xa,ya,xb,yb:integer;vanish:boolean); assembler;
var
 twodelx,delx,twodely:integer;
 xincr:integer;
 steep:boolean;

asm

push bp
push si
push di


mov cx, xa
mov dx, ya

mov ax,xb
sub ax,cx
mov bx,1
jge @xOK
neg ax
neg bx

@xok:
mov si,yb
sub si,dx
mov di,1
jge @yok
neg si
neg di

@yok:
mov steep,0
cmp si,ax

jng @notsteep
mov steep,1
xchg cx,dx
xchg ax,si
xchg bx,di

@notsteep:
mov delx,ax
shl si,1
mov twodely,si
sub si,ax
shl ax,1
mov twodelx,ax
mov xincr,bx

sub bh,bh

mov ax,$a000
mov es, ax

cmp vanish,0
jz @plotloop
jnz @plotloop1

@plotloop:
cmp steep,0
jz @noswap
xchg cx, dx

mov bx, dx
mov ax, 320
imul bx
add ax, cx
push di
mov di, ax
inc WORD PTR es:[di]
pop di
mov dx, bx

xchg cx,dx
jmp @update

@noswap:

mov bx, dx
mov ax, 320
imul bx
add ax, cx
push di
mov di, ax
inc WORD PTR es:[di]
pop di
mov dx, bx

@update:
test si, si
jnge @NOyincr
add dx,di
sub si, twodelx

@noyincr:
add cx,xincr
add si,twodely
dec delx
jge @plotloop
jmp @done1



@plotloop1:
cmp steep,0
jz @noswap1
xchg cx,dx

mov bx, dx
mov ax, 320
imul bx
add ax, cx
push di
mov di, ax
dec WORD PTR es:[di]
pop di
mov dx, bx

xchg cx,dx
jmp @update1

@noswap1:
mov bx, dx
mov ax, 320
imul bx
add ax, cx
push di
mov di, ax
dec WORD PTR es:[di]
pop di
mov dx, bx

@update1:
test si, si
jnge @NOyincr1
add dx,di
sub si, twodelx

@noyincr1:
add cx,xincr
add si,twodely
dec delx
jge @plotloop1

@done1:
pop di
pop si
pop bp

end;

procedure DOLINE(thisone:linest;vanish:boolean);
begin
 dolineasm(thisone.points[1].x,thisone.points[1].y,thisone.points[2].x,thisone.points[2].y,vanish);
end;

(* now to build the color pallet *)

procedure buildClut(pallettype:integer);
var
 temp:integer;
 temp1:integer;
 tempcolor:colregs;
begin

 for temp := 0 to 255 do
  for temp1 := 0 to 2 do
   thesecolors[temp][temp1] := 0;
 tempcolor := thesecolors[0];
 case pallettype of

 {----------------------------------------------------------------------}
  1: begin
   for temp := 1 to 21 do
    begin
     thesecolors[temp][0] :=    0;
     thesecolors[temp][1] :=    (temp)*3;
     thesecolors[temp][2] :=    (21-temp)*3;

     thesecolors[temp+21][0] := (temp)*3;
     thesecolors[temp+21][1] := (21-temp)*3;
     thesecolors[temp+21][2] := 0;

     thesecolors[temp+42][0] := (21-temp)*3;
     thesecolors[temp+42][1] := 0;
     thesecolors[temp+42][2] := (temp)*3;
    end;
   for temp := 1 to 63 do
    begin
     thesecolors[temp+63] := thesecolors[temp];
     thesecolors[temp+126] := thesecolors[temp];
     thesecolors[temp+189] := thesecolors[temp];
    end;
   for temp := 1 to 4 do
    begin
     thesecolors[temp+251][0] := 0;
     thesecolors[temp+251][1] := 0;
     thesecolors[temp+251][2] := 63;
    end;
  end;
 {-------------------------------------------------------------}
  2: begin
  for temp := 0 to 63 do
    begin
     thesecolors[temp][2] := 63-temp;
     thesecolors[temp][1] := temp;
     thesecolors[temp][0] := 0;
     thesecolors[temp+63][2] := 0;
     thesecolors[temp+63][1] := 63- temp;
     thesecolors[temp+63][0] := temp;
     thesecolors[temp+127][0] := 63 - temp;
     thesecolors[temp+127][1] := 0;
     thesecolors[temp+127][2] := temp;
     thesecolors[temp+191][0] := 63-temp;
     thesecolors[temp+191][1] := 63-temp;
     thesecolors[temp+191][2] := 63-temp;
    end;
  end;
 {---------------------------------------------------------------}
  3: begin
  for temp := 0 to 63 do
    begin
     thesecolors[temp][2] := temp;
     thesecolors[temp][1] := temp;
     thesecolors[temp][0] := temp;
     thesecolors[temp+63][2] := 63-temp;
     thesecolors[temp+63][1] := 63-temp;
     thesecolors[temp+63][0] := 63-temp;
     thesecolors[temp+127][0] := temp;
     thesecolors[temp+127][1] := temp;
     thesecolors[temp+127][2] := temp;
     thesecolors[temp+191][0] := 63-temp;
     thesecolors[temp+191][1] := 63-temp;
     thesecolors[temp+191][2] := 63-temp;
    end;
  end;
 end; {case}
 thesecolors[0] := tempcolor;

 set256colors(thesecolors,0,255);
end;


function updatex:integer;
begin
with mylines[ptr] do
 begin
  if ((points[temp].x + xmove[temp]) < 0) or ((points[temp].x + xmove[temp]) > ourx-1) then
   begin
    xmove[temp] := 0 - xmove[temp];
    if abs(xmove[temp]) <> xmove[temp] then
     xmove[temp] := 0 - random (maxmove) - 1
    else
     xmove[temp] := random (maxmove) + 1;
   end;
  updatex := points[temp].x + xmove[temp];
 end;
end;

function updatey:integer;
begin
with mylines[ptr] do
 begin
  if ((points[temp].y + ymove[temp]) < 0) or ((points[temp].y + ymove[temp]) >oury-1) then
   begin
    ymove[temp] := 0 - ymove[temp];
    if abs(ymove[temp]) <> ymove[temp] then
     ymove[temp] := 0 - random (maxmove) - 1
    else
     ymove[temp] := random(maxmove) + 1;
   end;
  updatey := points[temp].y + ymove[temp];
 end;
end;

procedure scrollcolors;
var
 tempcolor:colregs;
 temp: byte;
begin

 tempcolor := thesecolors[1];
 for temp := 1 to 254 do
  thesecolors[temp] := thesecolors[temp + 1];
 thesecolors[255] := tempcolor;
 set256colors(thesecolors,1,255);

end;

{---------------------------------------------------------------}

procedure initlines;
begin
 for temp := 1 to 2 do
 begin
  while xmove[temp] = 0 do
   xmove[temp] := random (maxmove * 2) -maxmove;
  while ymove[temp] = 0 do
   ymove[temp] := random (maxmove * 2) -maxmove;
  mylines[ptr].points[temp].newpoint(random(320),random(200),0);
 end;
 doline(mylines[ptr],false);
end;

begin

 cyclecolors := false;
 thispallet := 1;
 mynumlines := 1;
 vidmode := 1;
 maxmove := 1;
 ptr := 1;

 for temp := 1 to paramcount do begin
  tempstr := paramstr(temp);
  case ( upcase(tempstr[2])) of
   'C' :cyclecolors := true;
{   'V' :val(tempstr[3],vidmode,i);}
   'P' :val(tempstr[3],thispallet,i);
   'S' :val(tempstr[3],maxmove,i);
   '?','H' : begin
    killvideo;
    clrscr;
    writeln ('ShadeQix Screensaver  Version 1.0');
    writeln ('---------------------------------');
    writeln ('Coded by Gadianton, 1993         ');
    writeln ('---------------------------------');
    writeln ('Syntax:                          ');
    writeln ('Qixss [-P#] [-C] [#] [-V#] [-S#] ');
    writeln;
    writeln ('-P denotes Pallet number (0..4)  ');
    writeln ('-C denotes Color cycle activation');
    writeln ('-V denotes Video mode            ');
    writeln ('Numlines denotes #lines of Qix   ');
    writeln ('---------------------------------');
    writeln ('Pallets:                         ');
    writeln (' 1: tri-color spread (beautiful!)');
    writeln (' 2: 64 color spread (very smooth)');
    writeln ('---------------------------------');
    writeln ('If numlines is not present, then ');
    writeln ('an infinate number of lines will ');
    writeln ('be drawn                         ');
    writeln ('---------------------------------');
    writeln ('Press any key.                   ');
    repeat until (keypressed);
    tempstr := readkey;
    clrscr;
    writeln ('Video modes:                     ');
    writeln (' 1: 320x200x256 (works on all    ');
    writeln ('    cards, default)              ');
    writeln (' 2: 640x350x256 (et4000)         ');
    writeln (' 3: 640x480x256 (et4000)         ');
    writeln (' 4: 640x400x256 (et4000)         ');
    writeln (' 5: 800x600x256 (et4000)         ');
    writeln (' 6: 1024x768x256 (et4000)        ');
    writeln ('---------------------------------');
    writeln ('Press any key.                   ');
    repeat until (keypressed);
    tempstr := readkey;
    Halt(1);
   end;
  else
   val(tempstr,mynumlines,i);
  end;
 end;

 if mynumlines > 1024 then mynumlines := 1;
 if vidmode > 6 then vidmode := 1;
 if thispallet > 3 then thispallet := 1;
 if maxmove > 9 then maxmove := 9;

 randomize;
 activatevideo;

 case vidmode of
  1: begin setvidmode($13); ourx :=320;   oury:=200;   end;
  2: begin setvidmode($2d); ourx := 640;  oury := 350; end;
  3: begin setvidmode($2e); ourx := 640;  oury := 480; end;
  4: begin setvidmode($2f); ourx := 640;  oury := 400; end;
  5: begin setvidmode($30); ourx := 800;  oury := 600; end;
  6: begin setvidmode($38); ourx := 1024; oury := 768; end;
 end;
 ourx :=320;   oury:=200;

 buildclut(thispallet);
repeat
 initlines;

 repeat
  DMApixel(0,0,0);
  if cyclecolors then scrollcolors;
  for temp := 1 to 2 do
   templine.points[temp].newpoint(updatex,updatey,0);
  doline(templine,false);
  ptr := ptr + 1;
  if ptr = mynumlines+1 then ptr := 1;
  mylines[ptr] := templine;
  if ptr = mynumlines then if mynumlines > 1 then doline(mylines[1],true);
  if mynumlines > 1 then doline(mylines[ptr+1],true);
 until (keypressed);
 key:=readkey;
 if key = ' ' then begin
  killvideo;
  Case vidmode of
  1: begin setvidmode($13); ourx :=320;   oury:=200;   end;
  2: begin setvidmode($2d); ourx := 640;  oury := 350; end;
  3: begin setvidmode($2e); ourx := 640;  oury := 480; end;
  4: begin setvidmode($2f); ourx := 640;  oury := 400; end;
  5: begin setvidmode($30); ourx := 800;  oury := 600; end;
  6: begin setvidmode($38); ourx := 1024; oury := 768; end;
  end;
  buildclut(thispallet);
 end;
 until (key <> ' ');
 killvideo;
end.

