#include <windows.h>
#include "vis.h"


char szAppName[] = "AIMazing";
HWND adw[2];
int adw_reinit[2];

void initadw(int which);
winampVisModule *getModule(int which);
void config(struct winampVisModule *this_mod);
int init(struct winampVisModule *this_mod);
void quit(struct winampVisModule *this_mod);
int render(struct winampVisModule *this_mod);

winampVisHeader hdr = { VIS_HDRVER, "AIMazing v0.4", getModule };
winampVisModule mod;

__declspec( dllexport ) winampVisHeader *winampVisGetHeader()
{
	return &hdr;
}

BOOL WINAPI _DllMainCRTStartup(HANDLE hInst, ULONG ul_reason_for_call, LPVOID lpReserved)
{ // init mod here for size reduction
  mod.Config=config;
  mod.delayMs=10;
  mod.description="AIM Visualization";
  mod.spectrumNch=1;
  mod.waveformNch=1;
  mod.Init=init;
  mod.Render=render;
  mod.Quit=quit;
	return TRUE;
}


winampVisModule *getModule(int which)
{
  if (which==0) return &mod;
  return NULL;
}

void config(struct winampVisModule *this_mod)
{
  MessageBox(this_mod->hwndParent,
    "Aimazing v0.4. Makes aim more fun to keep open.\r\n\r\n"
    "By Justin, Steve, and Ian.",
    "About",MB_OK);
}

HWND findAdWindows(int which)
{
  HWND poo=FindWindow("_Oscar_BuddyListWin",NULL);
  HWND adw=NULL;
  if (poo) do
  {
    adw=FindWindowEx(poo,adw,"WndAte32Class",NULL);
  }
  while (adw && !(IsWindowVisible(adw) && !which--));
  return adw;
}

void initadw(int which)
{
  adw[which]=findAdWindows(which);
  if (adw[which])
  {
    HWND tmp=FindWindowEx(adw[which],NULL,NULL,NULL);
    if (tmp) SetWindowPos(tmp,NULL,0,0,0,0,SWP_NOACTIVATE|SWP_NOZORDER|SWP_NOMOVE);
  }
  adw_reinit[which]=0;
}

int init(struct winampVisModule *this_mod)
{
  int which;
  for (which = 0; which < 2; which++)
  {
    initadw(which);
  }
  render(this_mod);
	return 0;
}
void quit(struct winampVisModule *this_mod)
{
  int which;
  for (which = 0; which < 2; which++)
  {
    if (adw[which]) 
    {
      HWND tmp=FindWindowEx(adw[which],NULL,NULL,NULL);
      if (tmp) 
      {
        RECT r;
        GetWindowRect(adw[which],&r);
        SetWindowPos(tmp,NULL,0,0,r.right-r.left,r.bottom-r.top,SWP_NOACTIVATE|SWP_NOZORDER|SWP_NOMOVE);
      }
    }
  }
}

int render(struct winampVisModule *this_mod)
{
  int which;
  for (which = 0; which < 2; which ++)
  {
    int needinit=0;
    if (adw[which])
    {
      int w,h;
      RECT r;
      GetWindowRect(adw[which],&r);
      w=r.right-r.left;
      h=r.bottom-r.top;
      if (w&&h)
      {
        HDC hdc=GetDC(adw[which]);
        if (hdc)
        {
    	    int x;
          HDC memDC=CreateCompatibleDC(hdc);
          HBITMAP memBM=CreateCompatibleBitmap(hdc,w,h);
          HBITMAP oldBM=SelectObject(memDC,memBM);
          SelectObject(memDC,GetStockObject(LTGRAY_BRUSH));
          SelectObject(memDC,GetStockObject(BLACK_PEN));
	        Rectangle(memDC,0,0,w,h);
		      if (!which) 
          {
            for (x = 0; x < w; x ++)
		        {
              int y=(h*(this_mod->waveformData[0][(x*576)/w]^128))/256;
    		      if (x==0) MoveToEx(memDC,0,y,NULL);
			        else LineTo(memDC,x,y);
		        }
          }
		      else for (x = 0; x < w; x ++)
		      {
            int h2=(h*(this_mod->spectrumData[0][(x*128)/w]))/256;
            h2+=h2;
            if (h2>h)h2=h;
  		      MoveToEx(memDC,x,h,NULL);
			      LineTo(memDC,x,h-h2);
		      }
          BitBlt(hdc,0,0,w,h,memDC,0,0,SRCCOPY);
          SelectObject(memDC,oldBM);
          DeleteObject(memBM);
          DeleteObject(memDC);
          ReleaseDC(adw[which],hdc);
          adw_reinit[which]=0;
        }
        else adw_reinit[which]++;
      }
      else adw_reinit[which]++;
    }
    else adw_reinit[which]++;

    if (adw_reinit[which]>400) initadw(which);
  }
	return 0;
}
