using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using SimpleXB.Drawing;
using SimpleXB.Formats;

namespace SimpleXB
{
	/// <summary>
	/// Summary description for CanvasEdit.
	/// </summary>
	public class CanvasEdit : System.Windows.Forms.UserControl
	{
		Page page;
		private SimpleXB.Drawing.Palette customPalette = null;
		private SimpleXB.Drawing.Font customFont = null;
		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Page Page
		{
			get { return page; }
		}

		public Palette CustomPalette
		{
			get { return customPalette; }
			set { customPalette = value; }
		}

		public SimpleXB.Drawing.Font CustomFont
		{
			get { return customFont; }
			set { customFont = value; }
		}

		public CanvasEdit()
		{
			page = new Page(new Size(80, 4096));
			page.Loaded += new EventHandler(CanvasLoaded);
			InitializeComponent();
			this.AutoScroll = true;
			this.AutoScrollMinSize = page.PixelSize;
			
			//this.SetClientSizeCore(80*8, 4096*16);

			//CanvasView cv = new CanvasView();
			//cv.Location = new Point(0,0);
			//cv.Size = new Size(80*8, 4096*16);
			//this.Controls.Add(cv);


			// TODO: Add any initialization after the InitForm call
		}


		protected override void OnPaintBackground(PaintEventArgs pe)
		{
			//base.OnPaintBackground(pe);
		}

		private void CanvasLoaded(object sender, EventArgs e)
		{
			this.AutoScrollMinSize = page.PixelSize;
			this.Invalidate();
		}

		protected override void OnPaint(PaintEventArgs pe)
		{
			Graphics g = pe.Graphics;
			Rectangle rect = pe.ClipRectangle;
			Rectangle visRect = rect;
			rect.Offset(-AutoScrollPosition.X, -AutoScrollPosition.Y);
			SimpleXB.Drawing.Palette pal = (CustomPalette == null) ? page.Palette : CustomPalette;
			SimpleXB.Drawing.Font font = (CustomFont == null) ? page.Font : CustomFont;
			SimpleXB.Drawing.Canvas canvas = page.Canvas;

			if (rect.Left > AutoScrollMinSize.Width) rect.Size = new Size(0,0);
			if (rect.Right > AutoScrollMinSize.Width) rect.Size = new Size(AutoScrollMinSize.Width-rect.Left, rect.Height);
			if (rect.Top > AutoScrollMinSize.Height) rect.Size = new Size(0,0);
			if (rect.Bottom > AutoScrollMinSize.Height) rect.Size = new Size(rect.Width, AutoScrollMinSize.Height-rect.Top);

			if (rect.Width > 0 && rect.Height > 0)
			{

				Bitmap b = new Bitmap(rect.Width, rect.Height, PixelFormat.Format24bppRgb);
			
				BitmapData bd = b.LockBits(new Rectangle(0,0,rect.Width, rect.Height), ImageLockMode.WriteOnly, PixelFormat.Format24bppRgb);
		
				int fontWidth = page.Font.Width;
				int fontHeight = page.Font.Height;

				Point p = new Point(rect.Left / fontWidth, rect.Top / fontHeight);
				Point charp = new Point(rect.Left % fontWidth, rect.Top % fontHeight);
				CanvasElement ce;

				unsafe
				{
					int startX = rect.Left / fontWidth;
					int startFontX = rect.Left % fontWidth;
					Color foreColor;
					Color backColor;
					Color col;
					bool[] ba;
					byte* pRow;
					int x;
					byte* pByte = (byte*)bd.Scan0;
					
					for (int y=bd.Height-1; y>=0; y--)
					{
						p.X = startX;
						charp.X = startFontX;
						ce = canvas[p.X, p.Y];
						foreColor = pal[ce.Foreground];
						backColor = pal[(page.NonBlink) ? ce.Background : ce.Background & 0x7];
						ba = font[ce.Character][charp.Y];
						pRow = pByte;
						for (x=bd.Width-1; x>=0; x--)
						{
							col = (ba[charp.X]) ? foreColor :backColor;
							*(pRow++) = col.B;
							*(pRow++) = col.G;
							*(pRow++) = col.R;
							
							charp.X++;
							if (charp.X >= fontWidth)
							{
								charp.X = 0;
								p.X++;
								if (p.X >= canvas.CanvasSize.Width) break;
								ce = canvas[p.X, p.Y];
								foreColor = pal[ce.Foreground];
								backColor = pal[(page.NonBlink) ? ce.Background : ce.Background & 0x7];
								ba = font[ce.Character][charp.Y];
							}
							
						}
						pByte += bd.Stride;
						charp.Y++;
						if (charp.Y >= fontHeight)
						{
							charp.Y = 0;
							p.Y++;
							if (p.Y >= canvas.CanvasSize.Height) break;
						}
					}
				}
				b.UnlockBits(bd);
				//g.DrawImage(b, rect.Left, rect.Top, rect.Width, rect.Height);
				g.DrawImageUnscaled(b, visRect.Left, visRect.Top, visRect.Width, visRect.Height);
				b.Dispose();
			}
			Rectangle rectClip = visRect;
			if (rectClip.Right > AutoScrollMinSize.Width) rectClip.Width = AutoScrollMinSize.Width - rectClip.X;
			if (rectClip.Bottom > AutoScrollMinSize.Height) rectClip.Height = AutoScrollMinSize.Height - rectClip.Y;
			g.ExcludeClip(new Region(rectClip));

			Brush bb = new SolidBrush(Color.FromArgb(0,0,0));
			g.FillRectangle(bb, visRect);
			// Calling the base class OnPaint
			//base.OnPaint(pe);
		}


		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			// 
			// CanvasEdit
			// 
			this.Name = "CanvasEdit";
			this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.CanvasEdit_KeyPress);

		}
		#endregion


		private void CanvasEdit_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			return;	
		}

		protected override bool ProcessCmdKey(ref System.Windows.Forms.Message msg, System.Windows.Forms.Keys keyData)
		{
			switch (keyData)
			{
				case Keys.PageDown:
					AutoScrollPosition = new Point(-AutoScrollPosition.X, -AutoScrollPosition.Y+ClientSize.Height);
					return true;
				case Keys.PageUp:
					AutoScrollPosition = new Point(-AutoScrollPosition.X, -AutoScrollPosition.Y-ClientSize.Height);
					return true;
				case Keys.Down:
					AutoScrollPosition = new Point(-AutoScrollPosition.X, -AutoScrollPosition.Y+page.Font.Height);
					return true;
				case Keys.Up:
					AutoScrollPosition = new Point(-AutoScrollPosition.X, -AutoScrollPosition.Y-page.Font.Height);
					return true;
				case Keys.Left:
					AutoScrollPosition = new Point(-AutoScrollPosition.X-page.Font.Width, -AutoScrollPosition.Y);
					return true;
				case Keys.Right:
					AutoScrollPosition = new Point(-AutoScrollPosition.X+page.Font.Width, -AutoScrollPosition.Y);
					return true;
			}

			return base.ProcessCmdKey(ref msg, keyData);
		}
	}
}
