#include "stdafx.h"
#include "PabloDraw.h"
#include "cSocketFile.h"


cSocketFile::cSocketFile(CSocket* pSocket, BOOL bArchiveCompatible)
{
	m_pSocket = pSocket;
	m_bArchiveCompatible = bArchiveCompatible;

#ifdef _DEBUG
	ASSERT(m_pSocket != NULL);
	ASSERT(m_pSocket->m_hSocket != INVALID_SOCKET);

	int nType = 0;
	int nTypeLen = sizeof(int);
	ASSERT(m_pSocket->GetSockOpt(SO_TYPE,&nType,&nTypeLen));
	ASSERT(nType == SOCK_STREAM);
#endif // _DEBUG

	if (pSocket == NULL)
	{
		AfxThrowInvalidArgException();
	}
}

/////////////////////////////////////////////////////////////////////////////
// cSocketFile Implementation

cSocketFile::~cSocketFile()
{
}

UINT cSocketFile::Read(void* lpBuf, UINT nCount)
{
	ASSERT(m_pSocket != NULL);

	if (lpBuf == NULL)
	{
		AfxThrowInvalidArgException();
	}

	int nRead;

	if (!m_bArchiveCompatible)
	{
		int nLeft = nCount;
		PBYTE pBuf = (PBYTE)lpBuf;

		while(nLeft > 0)
		{
			nRead = m_pSocket->Receive(pBuf, nLeft);
			if (nRead == SOCKET_ERROR)
			{
				int nError = m_pSocket->GetLastError();
				AfxThrowFileException(CFileException::generic, nError);
				ASSERT(FALSE);
			}
			else if (nRead == 0)
			{
				return nCount - nLeft;
			}

			nLeft -= nRead;
			pBuf += nRead;
		}
		return nCount - nLeft;
	}

	nRead = m_pSocket->Receive(lpBuf, nCount, 0);
	if (nRead == SOCKET_ERROR)
	{
		int nError = m_pSocket->GetLastError();
		AfxThrowFileException(CFileException::generic, nError);
		ASSERT(FALSE);
	}
	return nRead;
}

void cSocketFile::Write(const void* lpBuf, UINT nCount)
{
	ASSERT (m_pSocket!=NULL);
	
	if (lpBuf == NULL)
	{
		AfxThrowInvalidArgException();
	}

	int nWritten = m_pSocket->Send(lpBuf, nCount);
	if (nWritten == SOCKET_ERROR)
	{
		int nError = m_pSocket->GetLastError();
		AfxThrowFileException(CFileException::generic, nError);
	}
}

void cSocketFile::Close()
{
	m_pSocket = NULL;
}

BOOL cSocketFile::Open(
	LPCTSTR /*lpszFileName*/, UINT /*nOpenFlags*/, CFileException* /*pError*/)
{
	AfxThrowNotSupportedException();
	return FALSE;
}

CFile* cSocketFile::Duplicate() const
{
	AfxThrowNotSupportedException();
	return NULL;
}

ULONGLONG cSocketFile::GetPosition() const
{
	AfxThrowNotSupportedException();
	return 0;
}

ULONGLONG cSocketFile::Seek(LONGLONG lOff, UINT nFrom)
{
	if (lOff != 0L || nFrom != current)
		TRACE(traceSocket, 0, "Warning - Attempt made to seek on a cSocketFile\n");
	return 0;
}

void cSocketFile::SetLength(ULONGLONG /*dwNewLen*/)
{
	AfxThrowNotSupportedException();
}

ULONGLONG cSocketFile::GetLength() const
{
	AfxThrowNotSupportedException();
	return 0;
}

void cSocketFile::LockRange(ULONGLONG /*dwPos*/, ULONGLONG /*dwCount*/)
{
	AfxThrowNotSupportedException();
}

void cSocketFile::UnlockRange(ULONGLONG /*dwPos*/, ULONGLONG /*dwCount*/)
{
	AfxThrowNotSupportedException();
}

void cSocketFile::Flush()
{
}

void cSocketFile::Abort()
{
	AfxThrowNotSupportedException();
}

UINT cSocketFile::GetBufferPtr(UINT nCommand, UINT /*nCount*/, 
	void** /*ppBufStart*/, void** /*ppBufMax*/)
{
	ASSERT(nCommand == bufferCheck);
	UNUSED(nCommand);

	return bufferBlocking;
}

#ifdef _DEBUG
void cSocketFile::AssertValid() const
{
	//CFile::AssertValid();
	if (m_pSocket != NULL)
		ASSERT_VALID(m_pSocket);
}

void cSocketFile::Dump(CDumpContext& dc) const
{
	CFile::Dump(dc);
	if (dc.GetDepth() > 0)
	{
		if (m_pSocket != NULL)
			dc << "with no socket\n";
		else
			dc << "with socket: " << m_pSocket;
	}
}
#endif //_DEBUG
