#ifndef __CCANVAS_H__
#define __CCANVAS_H__

#include "cOptions.h"

const LONG CANVAS_LASTCOLUMN_BUFFER    = 80;

typedef SHORT   tElementPart;
const tElementPart CANVAS_TRANSPARENT   = -1;

union sCanvasElement
{
    struct
    {
        UCHAR   attribute;
        UCHAR   character;
    };
    USHORT  value;

	inline UCHAR GetFore() { return attribute & 0x0f; }
	inline UCHAR GetBack() { return (attribute >> 4)& 0x0f; }
	inline void SetFore(UCHAR p_ucFore) { attribute = (attribute & 0xf0) | (p_ucFore & 0x0f); }
	inline void SetBack(UCHAR p_ucBack) { attribute = (attribute & 0x0f) | ((p_ucBack << 4 ) & 0x0f); }
	inline void Set(UCHAR p_ucCharacter, UCHAR p_ucFore, UCHAR p_ucBack)
	{
		character = p_ucCharacter;
		attribute = (p_ucFore & 0x0f) | ((p_ucBack & 0x0f) << 4);
	}
};

typedef sCanvasElement* tCanvasLine;

typedef tCanvasLine* tCanvasRows;

class cCanvas  
{
public:
    cCanvas(CSize p_size);
    virtual ~cCanvas();

    virtual BOOL Resize(CSize p_newsize);

    virtual void FlipX(cOptions* p_pOptions);
    virtual void FlipY(cOptions* p_pOptions);
    virtual void Rotate(cOptions* p_pOptions);

    virtual void Fill(tElementPart p_attribute, tElementPart p_character, CRect p_rectSelect = CRect(0,0,0,0));
    virtual void FillBack(tElementPart p_back, CRect p_rectSelect = CRect(0,0,0,0));
    virtual void FillFore(tElementPart p_fore, CRect p_rectSelect = CRect(0,0,0,0));
    virtual void FillAttr(tElementPart p_attribute, CRect p_rectSelect = CRect(0,0,0,0));
    virtual void FillChar(tElementPart p_character, CRect p_rectSelect = CRect(0,0,0,0));

    virtual void Set(cCanvas* p_pCanvas);
    virtual void Set(CPoint p_source, cCanvas* p_pCanvas, CPoint p_dest, LONG p_lWidth);
    virtual void Set(CPoint p_source, cCanvas* p_pCanvas, CPoint p_dest, CSize p_size);
    virtual void Set(CPoint p_source, cCanvas* p_pCanvas, CPoint p_dest, CSize p_size, cOptions* p_pOptions, BOOL p_bUnder, BOOL p_bTransparent);
    virtual void Set(CPoint p_point, sCanvasElement p_element);
    virtual void Set(CPoint p_point, tElementPart p_attribute, tElementPart p_character);
    virtual void Set(CRect p_rect, sCanvasElement p_element);
    virtual void Set(CRect p_rect, tElementPart p_attribute, tElementPart p_character);

    virtual sCanvasElement Get(CPoint p_point);


    virtual void SetAttr(CPoint p_point, tElementPart p_attribute);
    virtual void SetChar(CPoint p_point, tElementPart p_character);
    
    virtual void SetFore(CPoint p_point, tElementPart p_fore);
    virtual void SetBack(CPoint p_point, tElementPart p_back);


    virtual UCHAR GetFore(CPoint p_point);
    virtual UCHAR GetBack(CPoint p_point);


	virtual void SetLine(CPoint p_point, tElementPart p_attribute, tElementPart p_character, LONG p_lWidth = 0) = 0;
	virtual void SetLine(CPoint p_point, sCanvasElement p_element, LONG p_lWidth = 0);
    virtual void SetLine(CPoint p_point, const tCanvasLine p_line, LONG p_lWidth = 0);
    virtual void GetLine(CPoint p_point, tCanvasLine p_line, LONG p_lWidth = 0);
	virtual void InsertLine(int p_iLine);
	virtual void DeleteLine(int p_iLine);
    virtual void Delete(CRect p_rectSelect);
    UCHAR GetAttr(CPoint p_point);

	void SetColumn(CPoint p_point, tElementPart p_attribute, tElementPart p_character, LONG p_lHeight = 0);
	void SetColumn(CPoint p_point, sCanvasElement p_element, LONG p_lHeight = 0);
	virtual void InsertColumn(int p_iColumn) = 0;
	virtual void DeleteColumn(int p_iColumn) = 0;

    virtual int FindEndX(int p_iLine, int p_iStart = 0, int p_iEnd = 0);
    virtual int FindEndY();

    virtual void DeleteChar(CPoint p_point, BOOL p_bInsert = TRUE);
    virtual void InsertChar(CPoint p_point, sCanvasElement p_element, BOOL p_bInsert = TRUE);

    inline CSize   GetSize() const { return m_size; }

	inline void		SetAttribute(UCHAR p_fore, UCHAR p_back) { m_curAttribute = ((p_back << 4) & 0xF0) | (p_fore & 0x0F); }
	inline void		SetAttribute(UCHAR p_attr) { m_curAttribute = p_attr; }
	inline void		SetFore(UCHAR p_fore) { m_curAttribute = (m_curAttribute & 0xF0) | (p_fore & 0x0F); }
	inline void		SetBack(UCHAR p_back) { m_curAttribute = ((p_back << 4) & 0xF0) | (m_curAttribute & 0x0F); }
	inline tElementPart GetAttribute() const { return m_curAttribute; }
	inline UCHAR		GetFore() const { return (UCHAR)(m_curAttribute & 0x0F); }
	inline UCHAR		GetBack() const { return (UCHAR)((m_curAttribute & 0xF0) >> 4); }
	
	inline tElementPart GetChar() const { return m_curChar; }
	inline void			SetChar(tElementPart p_newChar) { m_curChar = p_newChar; }


protected:
    CSize           m_size;
	tElementPart	m_curAttribute;
	tElementPart	m_curChar;
	CMutex      m_mutex;

    virtual cCanvas* Create(CSize p_size) = 0;

    virtual void SetAttrInternal(CPoint p_point, UCHAR p_ucAttribute) = 0;
    virtual void SetCharInternal(CPoint p_point, UCHAR p_ucCharacter) = 0;
    virtual void SetForeInternal(CPoint p_point, UCHAR p_ucFore) = 0;
    virtual void SetBackInternal(CPoint p_point, UCHAR p_ucBack) = 0;

    virtual UCHAR GetAttrInternal(CPoint p_point) = 0;
    virtual UCHAR GetCharInternal(CPoint p_point) = 0;
    virtual void SetLineInternal(CPoint p_point, const tCanvasLine p_line, LONG p_lWidth = 0) = 0;
    virtual void GetLineInternal(CPoint p_point, tCanvasLine p_line, LONG p_lWidth = 0) = 0;

};




class cMemCanvas : public cCanvas
{
public:
    cMemCanvas(CSize p_size);
    virtual ~cMemCanvas();

    virtual BOOL Resize(CSize p_newsize);

    virtual void SetAttrInternal(CPoint p_point, UCHAR p_ucAttribute);
    virtual void SetCharInternal(CPoint p_point, UCHAR p_ucCharacter);
    virtual void SetForeInternal(CPoint p_point, UCHAR p_ucFore);
    virtual void SetBackInternal(CPoint p_point, UCHAR p_ucBack);
    virtual UCHAR GetAttrInternal(CPoint p_point);
    virtual UCHAR GetCharInternal(CPoint p_point);

    virtual void SetLineInternal(CPoint p_point, const tCanvasLine p_line, LONG p_lWidth = 0);
    virtual void GetLineInternal(CPoint p_point, tCanvasLine p_line, LONG p_lWidth = 0);
	virtual void SetLine(CPoint p_point, tElementPart p_attribute, tElementPart p_character, LONG p_lWidth = 0);
	virtual void InsertLine(int p_iLine);
	virtual void DeleteLine(int p_iLine);
	virtual void InsertColumn(int p_iColumn);
	virtual void DeleteColumn(int p_iColumn);

	virtual int FindEndY();
protected:
    tCanvasRows m_pData;
    

    virtual cCanvas* Create(CSize p_size);

};


#endif