#pragma once


#include "PabloDraw.h"
#include "ClientSocket.h"
#include "ClientSocketThread.h"
#include "ServingSocket.h"
#include "ListeningSocket.h"
#include "ListeningSocketThread.h"
#include "CanvasView.h"

//#define USE_THREADED_CLIENT  // this is bad

struct sListenThreadInfo
{
    CPabloDrawDoc*  pDoc;
    UINT            uiPort;
};

class CPabloDrawDoc : public CDocument
{
public:
    CPabloDrawDoc();
    CPabloDrawDoc(CPabloDrawDoc* pDoc);
    virtual ~CPabloDrawDoc();
protected: // create from serialization only
    DECLARE_DYNCREATE(CPabloDrawDoc)


	CPabloDrawApp* GetApp() { return (CPabloDrawApp*)AfxGetApp(); }

    BOOL LoadFile(LPCTSTR tszFilename);
    void UpdateRegion(CRect& rect, CCanvasView* pCurView = NULL);
	void UpdateRegion(CRectArray& arrRect, CCanvasView* pCurView = NULL);
	void SendMessage(UINT message, WPARAM wparam = 0, LPARAM lparam = 0);
	void PostMessage(UINT message, WPARAM wparam = 0, LPARAM lparam = 0);
    void DeleteClient(BOOL p_bRemoveFromServer = TRUE);
//    inline CListeningSocket*  GetListenSocket() { return m_pListenSocket; }
#ifdef USE_THREADED_CLIENT	
	inline CClientSocket*  GetClientSocket() { return (m_pClientThread) ? m_pClientThread->m_pClientSocket : NULL; }
#else
	inline CClientSocket*  GetClientSocket() { return m_pClientSocket; }
#endif
	inline CMutex* GetCriticalSection() { return &m_criticalSection; }
private:
#ifdef USE_THREADED_CLIENT	
	CClientSocketThread*	m_pClientThread;
#else
	CClientSocket*			m_pClientSocket;
#endif
	CListeningSocket*		m_pListeningSocket;
	CListeningSocketThread*		m_pListeningSocketThread;
	CMutex					m_criticalSection;
	CEvent					m_eventDone;
	CEvent					m_eventDoneInit;

// Operations
public:
	static CString GetFormatString(int formatType);

// Overrides
	public:
	virtual BOOL OnNewDocument();
	BOOL OnNewDocument(CSize p_sizeCanvas);
	virtual void Serialize(CArchive& ar);
	virtual BOOL OnOpenDocument(LPCTSTR lpszPathName);
	virtual BOOL OnSaveDocument(LPCTSTR lpszPathName);
	virtual void OnCloseDocument();
	BOOL CheckDisconnect();

// Implementation
public:
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif
/*    inline cCanvas* GetCanvas() { return m_pCanvas; }
    inline cFont* GetFont() { return m_pFont; }
    inline cPalette* GetPalette() { return m_pPalette; }
*/
//    inline tPageList* GetPageList() { return &m_pageList; }
	cPage*	GetCurrentPage() { return (m_pageList.IsEmpty()) ? NULL : m_pageList.GetHead(); }

	inline int GetCurrentCharSet() { return m_iCurrentCharSet; }
	inline void SetCurrentCharSet(int p_iCurrentCharSet) { m_iCurrentCharSet = p_iCurrentCharSet; }
	virtual void SetPathName(LPCTSTR lpszPathName, BOOL bAddToMRU = TRUE);

protected:
    tPageList m_pageList;
	int m_iCurrentCharSet;

	DECLARE_MESSAGE_MAP()
// Generated message map functions
public:
	afx_msg void OnFileSave();
	afx_msg void OnFileSaveAs();
	afx_msg void OnCanvasBreakconnection();
	afx_msg void OnCanvasConnecttoserver();
	afx_msg void OnCanvasStartserver();
	afx_msg void OnUpdateCanvasBreakconnection(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCanvasConnecttoserver(CCmdUI* pCmdUI);
	afx_msg void OnUpdateCanvasStartserver(CCmdUI* pCmdUI);

protected:
	virtual BOOL SaveModified();
public:
//	afx_msg void OnFileNew();
};

