#pragma once

#include "cMenu.h"

class CCanvasView : public CScrollView
{
	friend class CPreviewWindow;
public:
	CCanvasView(BOOL p_bSimpleMode = FALSE);           // protected constructor used by dynamic creation
	virtual ~CCanvasView();
	DECLARE_DYNCREATE(CCanvasView)

	void SetPreview(BOOL p_bIsPreview) { m_bIsPreview = p_bIsPreview; }
	BOOL IsPreview() { return m_bIsPreview; }

	BOOL BlockSelectMode() { return m_bBlockSelectMode; }
	void LoadFile(LPCTSTR p_tszFileName);

// Attributes
public:
    void UpdateRegion(CRect& rect);

// Overrides
	virtual void OnInitialUpdate();
	void		ScaleFont(int p_iFontWidth);
	void		GetScrollSize(CSize& sizeSb);
	CRect		GetVisibleRect(BOOL p_bUseReal = FALSE);
	CPoint		GetCursorPosition() { return m_curpoint; }


	void		GetEditMenu(cCommandList& p_cl, cMenuItemList& p_items, BOOL p_bBlockPasteMode = FALSE, BOOL p_bBlockSelectMode = FALSE);
	void		GetBlockMenu(cCommandList& p_cl, cMenuItemList& p_items, BOOL p_bBlockPasteMode = FALSE, BOOL p_bBlockSelectMode = FALSE);
	void		GetFillMenu(cCommandList& p_cl, cMenuItemList& p_items);

protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView);

    virtual BOOL PreCreateWindow( CREATESTRUCT& cs );
	void SetAccelerators();

	void CheckShiftSelect();

#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

    CPoint		m_curpoint;
    CSize		m_cursorSize;
	CPoint		m_lastMousePoint;
    CPalette	m_pal;
	double		m_dScale;
	cFont		m_font;
	CSize		m_sizeScaleChar;
	CSize		m_sizeScaleCanvas;
	BOOL		m_bIsAccelerator;
	BOOL		m_bUseAmigaFont;

	BOOL		m_bCaptureMouse;

	BOOL		m_bIsTyping;

	int			m_iCurrentCharSet;
	HACCEL		m_hMainAccel;
	HACCEL		m_hNormalAccel;
	HACCEL		m_hBlockAccel;
	HACCEL		m_hPasteAccel;
	BOOL		m_bIsPreview;
	BOOL		m_bBlinkOn;
	BOOL		m_bSimpleMode;   // for when user needs to select a character to fill with

	BOOL		m_bBlockSelectMode;  // true if selecting a block
	CRect		m_rectSelected;
	CPoint		m_ptSelected;

	BOOL		m_bBlockPasteMode;
	BOOL		m_bPasteTransparent;
	BOOL		m_bPasteUnder;
	CRect		m_rectClear;
	CRect		m_rectPaste;
	CPoint		m_ptMouseLast;

	void ScrollToCursor();
	void UpdateBlockSelection();

	afx_msg void OnMoveCanvasEnd();
	afx_msg void OnMoveCanvasHome();
	afx_msg void OnMoveLineEnd();
	afx_msg void OnMoveLineHome();
	afx_msg void OnMoveDown();
	afx_msg void OnMoveLeft();
	afx_msg void OnMoveRight();
	afx_msg void OnMoveUp();
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnMovePgdn();
	afx_msg void OnMovePgup();
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
    afx_msg void OnLButtonDown( UINT nFlags, CPoint point );
	afx_msg void OnCharBackspace();
	afx_msg void OnCharDelete();
	afx_msg void OnDrawChar(UINT nID);
	afx_msg void OnFileLoad();
	afx_msg void OnMoveLineNext();
	afx_msg void OnToggleInsert();
	afx_msg void OnAttrBackNext();
	afx_msg void OnAttrBackPrev();
	afx_msg void OnAttrForeNext();
	afx_msg void OnAttrForePrev();

	afx_msg void OnColumnDelete();
	afx_msg void OnColumnInsert();
	afx_msg void OnLineDelete();
	afx_msg void OnLineInsert();
	afx_msg void OnGetColour();
	afx_msg void OnViewFont80x50();
	afx_msg void OnViewFont80x25();
	afx_msg void OnViewFontAmiga();
	afx_msg void OnUpdateViewFontChange(CCmdUI *pCmdUI);

	afx_msg void OnSwitchFont();
	afx_msg LRESULT OnDoRealize(WPARAM wParam, LPARAM lParam);  // user message
    afx_msg void OnUpdatePos(CCmdUI* pCmdUI);
	afx_msg LRESULT OnAddMessage(WPARAM wparam, LPARAM lparam);
	afx_msg LRESULT OnUserJoined(WPARAM wparam, LPARAM lparam);
	afx_msg LRESULT OnUserParted(WPARAM wparam, LPARAM lparam);
	afx_msg LRESULT OnUpdateCanvas(WPARAM wparam, LPARAM lparam);
	
	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnSetCharset(UINT nID);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSysChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	virtual BOOL PreTranslateMessage(MSG* pMsg);

	afx_msg void OnUpdateCutCopy(CCmdUI* pCmdUI);

    afx_msg void OnEditCopy();
    afx_msg void OnEditCut();
    afx_msg void OnEditPaste();
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg LRESULT OnFullScreenSwitch(WPARAM wParam, LPARAM lParam);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnBlockSelect();
	afx_msg void OnBlockExit();
	afx_msg void OnFill();
	afx_msg void OnFillAttribute();
	afx_msg void OnFillBacgroundonly();
	afx_msg void OnFillBothcharacterattribute();
	afx_msg void OnFillCharacter();
	afx_msg void OnFillForeground();
	afx_msg void OnToolsStarttyping();
	afx_msg UINT OnGetDlgCode();
	afx_msg void OnEditDelete();
	afx_msg void OnEditErase();
	afx_msg void OnEditClear();
	BOOL OnProcessCommand(UINT nID);
	CPoint GetCursorPoint(CPoint p_ptPixelOffset);
	afx_msg void OnUpdateBlockPaste(CCmdUI *pCmdUI);
	afx_msg void OnBlockRotate();
	afx_msg void OnBlockFlipx();
	afx_msg void OnBlockFlipy();
	afx_msg void OnBlock();
	afx_msg void OnBlockTransparent();
	afx_msg void OnBlockUnder();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnUpdateCommand(CCmdUI *pCmdUI);
	afx_msg LRESULT OnKillClient(WPARAM wParam, LPARAM lParam);
};

