unit control;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
interface uses skaUnit,crt;
Procedure cursor_off;
Procedure cursor_on;
Function inputStr(xPos,yPos,sColor,sLength : byte; sDef : string) : string;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
implementation
Procedure cursor_off; Assembler;
 asm
  mov ax,0100h
  mov cx,2607h
  int 10h
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Procedure cursor_on; Assembler;
 asm
  mov ax,0100h
  mov cx,0506h
  int 10h
 end;
{:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::}
Function inputStr(xPos,yPos,sColor,sLength : byte; sDef : string) : string;
 var iStrBuffer : string[255];
     iCurReal   : byte;
     iCurPos    : byte;
     iStart     : byte;
     iInKey     : char;
     iDone      : boolean;
     iTempCount : byte;

 Procedure iUpdateDisplay; { using |B1 as the background }
  var uCounter : byte;
      uOldAttr : byte;
  begin
   uOldAttr := textAttr;
   gotoXY(xPos,yPos);
   textAttr := 16+sColor;
   for uCounter := iStart to pred(sLength) do
       if (succ(uCounter)<=ord(iStrBuffer[0])) then
           write(iStrBuffer[succ(uCounter)]) else
           write(#32);
   gotoXY(xPos+iCurPos,yPos);
   textAttr := uOldAttr;
  end;

 begin
  cursor_on; iStart := 0; iCurReal := 0; iCurPos := 0; iDone := false;
  iStrBuffer := sDef;
  iUpdateDisplay;
  while (iDone=false) do
   begin
    iInKey := readKey;
    case iInKey of
     #0  : case readKey of
            #75 : begin {left}
                  if (iCurPos>0) then begin dec(iCurPos); dec(iCurReal); end else
                  if (iCurPos=0) then if (iStart>0) then begin dec(iCurReal); dec(iStart); end;
                  iUpdateDisplay;
                  end;
            #77 : begin {right}
                  if (iCurPos<sLength) then begin inc(iCurPos); inc(iCurReal); end;
                  iUpdateDisplay;
                  end;
           end;
    #13  : iDone := true;
    #27  : begin iStrBuffer := sDef; iDone := true; end;
    #8   : begin {bckspc}
            if (iCurReal>0) then
                 begin
                  if (iCurReal<=ord(iStrBuffer[0])) then
                   begin
                    for iTempCount := iCurReal to ord(iStrBuffer[0]) do
                     iStrBuffer[iTempCount] := iStrBuffer[iTempCount+1];
                     dec(iStrBuffer[0]);
                     iStrBuffer[ord(iStrBuffer[0])+1] := #32;
                     if (iCurPos>0) then begin dec(iCurPos); dec(iCurReal) end;
                   end else {just go left}
                    begin
                     if (iCurPos>0) then begin dec(iCurPos); dec(iCurReal); end else
                     if (iCurPos=0) then if (iStart>0) then begin dec(iCurReal); dec(iStart); end;
                    end;
                   iUpdateDisplay;
                  end;
                 end
    else begin
         iStrBuffer[iCurReal+1] := iInkey;
         if (iCurPos<sLength) then
          begin
          inc(iCurReal);
          inc(iCurPos);
          if (ord(iStrBuffer[0])<iCurReal) then inc(iStrBuffer[0]);
          end;
         iUpdateDisplay; { gotoxy(1,1);write('iCurReal^^=',iCurReal,'|iStrBuf[0]=',ord(iStrBuffer[0])); }
         end;
    end;
   end;
  cursor_off;
  inputStr := iStrBuffer;
 end;
end.