/***************************************************************************
 *                                                                         *
 * avX.h:                                                                  *
 *                                                                         *
 * AcidView For X - main include                                           *
 * Written by Sean Kasun                                                   *
 *                                                                         *
 * Copyright 1995-1998, ACiD Productions                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AVX_H
#define AVX_H

/* File types */
#define tNone 0
#define tAnsi 1
#define tRip 2

/* Key codes */
#define kUp 98
#define kDown 104
#define kPgUp 99
#define kPgDown 105
#define kHome 97
#define kEnd 103

/* custom types */
typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned long dword;


/* Standard Xt MenuItem structure */
typedef struct {
    char *title;
    void (*callback)();
} MenuItem;

/* Standard Xt MenuBar structure */
typedef struct {
    char *title;
    char *shell;
    MenuItem *item;
    Cardinal numitems;
} MenuBar;

extern XtAppContext app_con;	/* application context */

/* Our widgets for the look & feel */
extern Widget topLevel,menubox,openwin;
extern Widget owframe,owlframe,owview,owlist,owfilter,owpath,
	owfilename,owselect,owfilterp,owpathp;

extern char curdir[255];	/* current directory */
extern char showntype,ansMode;
extern Colormap mycmap;		/* main color map */
extern char curmask[255];
extern Font dos25font,dos50font;  /* our fonts */

extern Display *display;	/* main display */
extern Window window;		/* main window */

void quit();

#endif
