/***************************************************************************
 *                                                                         *
 * avX-win.c                                                               *
 *                                                                         *
 * AcidView For X - GUI routines                                           *
 * Written by Sean Kasun                                                   *
 *                                                                         *
 * Copyright 1995-1998, ACiD Productions                                   *
 *                                                                         *
 ***************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/SmeBSB.h>
#include "avX.h"
#include "avX-win.h"

/* build menu bar */
CreateMenuBar(MenuBar *menubar,int nummenus)
{
    int i,j;
    Widget w,iw;
    static Arg menuargs[]={
	{XtNmenuName,(XtArgVal)NULL}
    };
    static Arg itemargs[]={
	{XtNtitle,(XtArgVal)NULL},
	{XtNsensitive,(XtArgVal)True}
    };


    for (i=0;i<nummenus;i++) {
	menuargs[0].value=(XtArgVal) menubar[i].shell;
	w=XtCreateManagedWidget(menubar[i].title,
				menuButtonWidgetClass,menubox,
				menuargs,XtNumber(menuargs));
	w=XtCreatePopupShell(menubar[i].shell,simpleMenuWidgetClass,
			   w,NULL,0);
	for (j=0;j<menubar[i].numitems;j++) {
	    itemargs[0].value=(XtArgVal) menubar[i].item[j].title;
	    if (menubar[i].item[j].title==NULL)
	      XtCreateManagedWidget("line",
				    smeLineObjectClass,w,NULL,0);
	    else {
		if (menubar[i].item[j].callback==NULL)
		  itemargs[1].value=False;
		else
		  itemargs[1].value=True;
		iw=XtCreateManagedWidget(menubar[i].item[j].title,
					 smeBSBObjectClass,w,
					 itemargs,XtNumber(itemargs));
		if (menubar[i].item[j].callback!=NULL)
		  XtAddCallback(iw,XtNcallback,
				menubar[i].item[j].callback,NULL);
	    }
	}		
    }
}

/* redraw screen */
void Redraw()
{
    if (showntype==tAnsi)		/* redraw ansi */
      showansi();
	/* the following is commented because it never needs redrawing */
    /*if (showntype==tRip)
      showrip();*/
}
