/***************************************************************************
 *                                                                         *
 * avX-rip.c:                                                              *
 *                                                                         *
 * AcidView For X - rip parser                                             *
 * Written by Sean Kasun                                                   *
 *                                                                         *
 * Copyright 1995-1998, ACiD Productions                                   *
 *                                                                         *
 ***************************************************************************/


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include "avX.h"
#include "avX-rip.h"

static char readone(FILE *myfile);
static void readtext(FILE *myfile);
static int megaread(FILE *myfile);

byte endofrip,waitingbar;
byte currentcolour;
word linethickness,linestyle,userline1,userline2,userline;
word fillpattern,fillcolour;
word bezcount,beztemp;
byte userfillpattern[8];
word tempx,tempy,linex1,linex2,liney1,linex2,liney2,currentx,currenty;
word xradius,yradius,radius;
word startangle,endangle;
word numpoints;
int floodborder;
short resultcolour;
word whichcolour;
XPoint bezpoints[3];
word writemode;
int a;
XPoint *polygonpoints;
char ripouttext[255];
GC ripgc,ripfgc;
/* our default palette. 16 colors out of a possible 64 */
int defpal[]={0,1,2,3,4,5,0x14,7,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f};
int colrx[16];
XColor colr;
int rippalette[16];
int tempint;
/* the big list of patterns for drawing */
char patterns[][8]={
    {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
    {0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff},
    {0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80},
    {0x0f,0x1e,0x3c,0x78,0xf0,0xe1,0xc3,0x87},
    {0x87,0xc3,0xe1,0xf0,0x78,0x3c,0x1e,0x0f},
    {0x2d,0x5a,0xb4,0x69,0xd2,0xa5,0x4b,0x96},
    {0xff,0x01,0x01,0x01,0xff,0x01,0x01,0x01},
    {0x08,0x14,0x22,0x41,0x80,0x41,0x22,0x14},
    {0xf0,0x0f,0xf0,0x0f,0xf0,0x0f,0xf0,0x0f},
    {0x80,0x00,0x01,0x00,0x80,0x00,0x01,0x00},
    {0x08,0x00,0x21,0x00,0x08,0x00,0x21,0x00}
};
Pixmap pattern;

void setpalette(short,word);
void setallpalette(void);

void parserip(FILE *myfile)
{
    XGCValues vals;
    char ch;
    int i;

	/* make our default pattern */
    pattern=XCreatePixmapFromBitmapData(display,window,
					patterns[0],8,8,
					1,0,1);

    XClearWindow(display,window);

	/* nuke color map */
	if (mycmap!=0) {
			XFreeColormap(display,mycmap);
			mycmap=0;
	}
	/* make color map */
		mycmap=XCreateColormap(display,window,
			 DefaultVisual(display,DefaultScreen(display)),
			AllocNone);
	XSetWindowColormap(display,window,mycmap);

	/* clear out our polygon array */
    polygonpoints=(XPoint *)malloc(512*sizeof(XPoint));

	/* make our palette, same routine as in avX-ansi.c */
#define PALRANGE 65535
#define MINSHADE PALRANGE/3
#define MEDSHADE MINSHADE*2
    for (i=0;i<16;i++) {
	colr.red=((defpal[i]&32)/32)*MINSHADE;
	colr.red+=((defpal[i]&4)/4)*MEDSHADE;
	colr.green=((defpal[i]&16)/16)*MINSHADE;
	colr.green+=((defpal[i]&2)/2)*MEDSHADE;
	colr.blue=((defpal[i]&8)/8)*MINSHADE;
	colr.blue+=(defpal[i]&1)*MEDSHADE;
	XAllocColor(display,mycmap,&colr);
	colrx[i]=colr.pixel;
    }
    vals.background=colrx[0];
    vals.foreground=colrx[7];
    vals.stipple=pattern;
    vals.fill_style=FillStippled;
    ripgc=XCreateGC(display,window,
		GCBackground|GCForeground,&vals);
    ripfgc=XCreateGC(display,window,
		 GCBackground|GCForeground|GCStipple|GCFillStyle,&vals);
    currentx=0;
    currenty=0;
    waitingbar=0;
    endofrip=0;
    do {
	ch=readone(myfile);
	if (ch=='!') {
		while (ch!=26 && ch!=10 && !endofrip) {
			do {
				if (waitingbar) {
					ch='|';
					waitingbar=0;
				} else
					ch=readone(myfile);
			} while (ch!='|' && ch!=10 && ch!=26);
		if (ch=='|') {
			ch=readone(myfile);
			switch(ch) {
				/* draw string at curpos */
				case 'T':
					readtext(myfile);
					XDrawString(display,window,ripgc,currentx,currenty+16,
						ripouttext,strlen(ripouttext));
					break;
				/* draw string at x/y */
				case '@':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					readtext(myfile);
					XDrawString(display,window,ripgc,tempx,tempy+16,
						ripouttext,strlen(ripouttext));
					break;
				/* ignore this one */
				case 'Y':
					megaread(myfile);
					megaread(myfile);
					megaread(myfile);
					megaread(myfile);
					break;
				/* set color */
				case 'c':
					currentcolour=megaread(myfile);
					if (currentcolour>15)
						currentcolour=15;
					vals.foreground=colrx[currentcolour];
					vals.background=colrx[currentcolour];
					XChangeGC(display,ripgc,GCForeground,&vals);
					break;
				/* draw point at x/y in current color */
				case 'X':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					XDrawPoint(display,window,ripgc,
						 tempx,tempy);
					break;
				/* draw line in current color */
				case 'L':
					linex1=megaread(myfile);
					liney1=megaread(myfile);
					linex2=megaread(myfile);
					liney2=megaread(myfile);
					XDrawLine(display,window,ripgc,
						linex1,liney1,linex2,liney2);
					break;
				/* draw rect */
				case 'R':
					linex1=megaread(myfile);
					liney1=megaread(myfile);
					linex2=megaread(myfile);
					liney2=megaread(myfile);
					if (linex2<linex1) {
						tempint=linex1;
						linex1=linex2;
						linex2=tempint;
					}
					if (liney2<liney1) {
						tempint=liney1;
						liney1=liney2;
						liney2=tempint;
					}
					XDrawRectangle(display,window,ripgc,
						 linex1,liney1,linex2-linex1,
						 liney2-liney1);
					break;
				/* set color */
				case 'a':
					whichcolour=megaread(myfile);
					resultcolour=megaread(myfile);
					setpalette(whichcolour,resultcolour);
					break;
				/* set palette */
				case 'Q':
					for (a=0;a<16;a++)
						rippalette[a]=megaread(myfile);
					setallpalette();
					break;
				/* set write mode (copy/xor) */
				case 'W':
					writemode=megaread(myfile);
					if (writemode==0)
						vals.function=GXcopy;
					if (writemode==1)
						vals.function=GXxor;
					XChangeGC(display,ripgc,GCFunction,&vals);
					XChangeGC(display,ripfgc,GCFunction,&vals);
					break;
				/* set current pos */
				case 'm':
					currentx=megaread(myfile);
					currenty=megaread(myfile);
					break;
				/* draw filled rect */
				case 'B':
					linex1=megaread(myfile);
					liney1=megaread(myfile);
					linex2=megaread(myfile);
					liney2=megaread(myfile);
					if (linex2<linex1) {
						tempint=linex1;
						linex1=linex2;
						linex2=tempint;
					}
					if (liney2<liney1) {
						tempint=liney1;
						liney1=liney2;
						liney2=tempint;
					}
					XFillRectangle(display,window,ripfgc,
						 linex1,liney1,linex2-linex1,
						 liney2-liney1);
					break;
				/* draw circle */
				case 'C':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					radius=megaread(myfile);
					XDrawArc(display,window,ripgc,tempx-radius,
						 tempy-radius,radius*2,radius*2,0,23040);
					break;
				/* draw arc */
				case 'O':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					startangle=megaread(myfile);
					endangle=megaread(myfile);
					xradius=megaread(myfile);
					yradius=megaread(myfile);
					XDrawArc(display,window,ripgc,tempx-xradius,
						 tempy-yradius,xradius*2,yradius*2,
						 startangle*64,endangle*64);
					break;
				/* draw filled oval */
				case 'o':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					xradius=megaread(myfile);
					yradius=megaread(myfile);
					XFillArc(display,window,ripfgc,tempx-xradius,
						 tempy-yradius,xradius*2,yradius*2,0,23040);
					break;
				/* draw poly */
				case 'P':
					numpoints=megaread(myfile);
					for (a=0;a<numpoints;a++) {
						polygonpoints[a].x=megaread(myfile);
						polygonpoints[a].y=megaread(myfile);
					}
					polygonpoints[a].x=polygonpoints[0].x;
					polygonpoints[a].y=polygonpoints[0].y;
					numpoints++;
					XDrawLines(display,window,ripgc,
						 polygonpoints,numpoints,CoordModeOrigin);
					break;
				/* draw filled poly */
				case 'p':
					numpoints=megaread(myfile);
					for (a=0;a<numpoints;a++) {
						polygonpoints[a].x=megaread(myfile);
						polygonpoints[a].y=megaread(myfile);
					}
					polygonpoints[a].x=polygonpoints[0].x;
					polygonpoints[a].y=polygonpoints[0].y;
					numpoints++;
					XFillPolygon(display,window,ripfgc,
						 polygonpoints,numpoints,Complex,
						 CoordModeOrigin);
					break;
				/* draw lines */
				case 'l':
					numpoints=megaread(myfile);
					for (a=0;a<numpoints;a++) {
						polygonpoints[a].x=megaread(myfile);
						polygonpoints[a].y=megaread(myfile);
					}
					XDrawLines(display,window,ripgc,
						 polygonpoints,numpoints,CoordModeOrigin);
					break;
				/* flood fill (not impl yet) */
				case 'F':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					floodborder=megaread(myfile);
					/*floodfill(tempx,tempy,floodborder);*/
					break;
				/* set line style */
				case '=':
					linestyle=megaread(myfile);
					userline1=megaread(myfile);
					userline2=megaread(myfile);
					linethickness=megaread(myfile);
					userline=(userline2*0xff)+userline1;
					if (linestyle==0)
						tempint=LineSolid;
					if (linestyle==1 || linestyle==2)
						tempint=LineOnOffDash;
					if (linestyle==3)
						tempint=LineDoubleDash;
					if (linestyle==4) /*XSetDashes*/
						tempint=LineDoubleDash;
					XSetLineAttributes(display,ripgc,
						 linethickness,tempint,CapNotLast,
						 JoinMiter);
					XSetLineAttributes(display,ripfgc,
						 linethickness,tempint,CapNotLast,
						 JoinMiter);
					break;
				/* set pattern */
				case 'S':
					fillpattern=megaread(myfile);
					fillcolour=megaread(myfile);
					vals.foreground=colrx[fillcolour];
					if (fillpattern>0 && fillpattern<12) {
						XFreePixmap(display,pattern);
						pattern=XCreatePixmapFromBitmapData(display,window,
							patterns[fillpattern-1],
							8,8,1,0,1);
						vals.stipple=pattern;
						XChangeGC(display,ripfgc,GCForeground|GCStipple,
							&vals);
					}
					break;
				/* draw bezier (not impl) */
				case 'Z':
					for (a=1;a<4;a++) {
						bezpoints[a-1].x=megaread(myfile);
						bezpoints[a-1].y=megaread(myfile);
					}
					bezcount=megaread(myfile);
					beztemp=bezcount*100;
					/*drawbezier(bezpoints,4,beztemp,currentcolour);*/
					break;
				/* draw arc */
				case 'A':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					startangle=megaread(myfile);
					endangle=megaread(myfile);
					radius=megaread(myfile);
					XDrawArc(display,window,ripgc,tempx-radius,
						 tempy-radius,radius*2,radius*2,
						 startangle*64,endangle*64);
					break;
				/* draw oval arc */
				case 'V':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					startangle=megaread(myfile);
					endangle=megaread(myfile);
					xradius=megaread(myfile);
					yradius=megaread(myfile);
					XDrawArc(display,window,ripgc,tempx-xradius,
						 tempy-yradius,xradius*2,yradius*2,
						 startangle*64,endangle*64);
					break;
				/* draw filled pie */
				case 'I':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					startangle=megaread(myfile);
					endangle=megaread(myfile);
					radius=megaread(myfile);
					XFillArc(display,window,ripfgc,tempx-radius,
						 tempy-radius,radius*2,radius*2,
						 startangle*64,endangle*64);
					break;
				/* draw filled oval pie */
				case 'i':
					tempx=megaread(myfile);
					tempy=megaread(myfile);
					startangle=megaread(myfile);
					endangle=megaread(myfile);
					xradius=megaread(myfile);
					yradius=megaread(myfile);
					XFillArc(display,window,ripfgc,tempx-xradius,
						 tempy-yradius,
						 xradius*2,yradius*2,
						 startangle*64,endangle*64);
					break;
				/* set user pattern */
				case 's':
					for (a=0;a<8;a++)
						userfillpattern[a]=megaread(myfile);
					fillcolour=megaread(myfile);
					vals.foreground=colrx[fillcolour];
					XFreePixmap(display,pattern);
					pattern=XCreatePixmapFromBitmapData(display,window,
						(char *)&userfillpattern,8,8,
						1,0,1);
					vals.stipple=pattern;
					XChangeGC(display,ripfgc,GCForeground|GCStipple,&vals);
					break;
				/* end of rip */
				case '#':
					endofrip=1;
					break;
				/* ignore bad codes */
				default:
					break;
				}
			}
		}
	}
    } while (ch!=26 && !endofrip);
    free(polygonpoints);
    XFreeGC(display,ripgc);
    XFreeGC(display,ripfgc);
    XFreePixmap(display,pattern);
}

/* read one byte */
static char readone(FILE *myfile)
{
    char mych;
    mych=fgetc(myfile);
    if (mych=='\\') {
		while (mych!=10 && mych!=26)
			mych=fgetc(myfile);
		mych=fgetc(myfile);
    } else
      if (mych==26)
		endofrip=1;
    return mych;
}

/* read a string of text */
static void readtext(FILE *myfile)
{
    char *ptr,ch;
    byte done;
    ptr=ripouttext;
    done=0;
    do {
		ch=fgetc(myfile);
		switch(ch) {
			case '|':
				done=1;
				waitingbar=1;
				break;
			case '\\':
				while (ch!=10 && ch!=26)
					ch=fgetc(myfile);
				ch=fgetc(myfile);
				*ptr++=ch;
				break;
			case 26:
				endofrip=1;
	    			done=1;
				break;
			case 13:
				done=1;
				break;
			case 10:
				done=1;
				break;
			default:
				*ptr++=ch;
		}
    } while (!done);
    *ptr=0;
}

/* read mega number */
static int megaread(FILE *myfile)
{
    char c1,c2;
    int temp;
    c1=readone(myfile);
    c2=readone(myfile);
    temp=0;
    if (c1>='0' && c1<='9')
      temp=c1-'0';
    if (c1>='A' && c1<='Z')
      temp=10+(c1-'A');
    temp*=36;
    if (c2>='0' && c2<='9')
      temp+=c2-'0';
    if (c2>='A' && c2<='Z')
      temp+=10+(c2-'A');
    return(temp);
}

void setpalette(short whichcolor,word resultcolor)
{
    colr.red=((resultcolor&32)/32)*MINSHADE;
    colr.red+=((resultcolor&4)/4)*MEDSHADE;
    colr.green=((resultcolor&16)/16)*MINSHADE;
    colr.green+=((resultcolor&2)/2)*MEDSHADE;
    colr.blue=((resultcolor&8)/8)*MINSHADE;
    colr.blue+=(resultcolor&1)*MEDSHADE;
    XAllocColor(display,mycmap,&colr);
    colrx[whichcolor]=colr.pixel;
}

void setallpalette()
{
    int i;
    for (i=0;i<16;i++) {
		colr.red=((rippalette[i]&32)/32)*MINSHADE;
		colr.red+=((rippalette[i]&4)/4)*MEDSHADE;
		colr.green=((rippalette[i]&16)/16)*MINSHADE;
		colr.green+=((rippalette[i]&2)/2)*MEDSHADE;
		colr.blue=((rippalette[i]&8)/8)*MINSHADE;
		colr.blue+=(rippalette[i]&1)*MEDSHADE;
		XAllocColor(display,mycmap,&colr);
		colrx[i]=colr.pixel;
    }
}




