/***************************************************************************
 *                                                                         *
 * avX-menu.c                                                              *
 *                                                                         *
 * AcidView For X - menu processing routines                               *
 * Written by Sean Kasun                                                   *
 *                                                                         *
 * Copyright 1995-1998, ACiD Productions                                   *
 *                                                                         *
 ***************************************************************************/


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Shell.h>
#include <X11/Xaw/Dialog.h>
#include <sys/stat.h>
#include <stdio.h>
#include <dirent.h>
#include <string.h>
#include "avX.h"
#include "avX-menu.h"
#include "avX-win.h"
#include "avX-ansi.h"
#include "avX-rip.h"

char **filelist;
int updatefiles();
void ReplaceFilename(Widget w);
void DoSelect(Widget w);
static void DoCancel(Widget w);
Boolean match(char *p,char *s);

/* exit routine */
void appExit()
{
    quit();
}

/* resize window */
void appSize()
{
    XResizeWindow(display,window,640,400);
}

/* color on, item */
void appFull()
{
    coltype=0;
    Redraw();
}

/* color off, item */
void appStrip()
{
    coltype=2;
    Redraw();
}

/* go through parents looking for shell */
static Widget GetShell(Widget widget)
{
    while ((widget!=NULL) && !XtIsShell(widget))
      widget=XtParent(widget);
    return (widget);
}

/* nuke the shell baby! */
static void DestroyShell(Widget widget)
{
    Widget shell=GetShell(widget);
    XtPopdown(shell);
    XtDestroyWidget(shell);
}

/* display about window */
void appAbout()
{
    Widget aboutwin,dialog;
    Arg args;
    XtSetArg(args,XtNlabel,"\
         The AcidView For X Project\n\
              Version 0.05\n\
\n\
(c)Copyright 1995-1998, ACiD Productions\n\
Written by Sean Kasun\n\
\n\
\n");

    aboutwin=XtCreatePopupShell("about",transientShellWidgetClass,
				topLevel,NULL,0);
    dialog=XtCreateManagedWidget("dialog",dialogWidgetClass,
				   aboutwin,&args,1);
    XawDialogAddButton(dialog,"Touch Me",(XtCallbackProc)DestroyShell,
		       (XtPointer)dialog);
    XtPopup(aboutwin,XtGrabExclusive);
}

void ReplaceFilename(Widget w)
{
    XawListReturnStruct *list=XawListShowCurrent(owlist);
    XtVaSetValues(owfilename,XtNstring,list->string,NULL);
    XawTextSetInsertionPoint(owfilename,
			     (XawTextPosition) strlen(list->string));
    XtFree((char *) list);
    DoSelect(w);
}

/* select file */
void DoSelect(Widget w)
{
    FILE *myfile;
    int i;
    char *filename;
    char *ext;
    ext=(char *)malloc(5);
    XtVaGetValues(owfilename,XtNstring,&filename,NULL);
    if (filename!=NULL) {
	/* go to dir */
	if (filename[strlen(filename)-1]=='/') {
	    chdir(filename);
	    getcwd(curdir,255);
	    updatefiles();
	    XawListChange(owlist,filelist,0,0,True);
	    XtVaSetValues(owpath,XtNlabel,curdir,NULL);
	} else {
		/* open it baby */
	    if ((myfile=fopen(filename,"rt"))==NULL) {
		printf("Couldn't open %s!",filename);
		quit();
	    }
	    strcpy(ext,filename+(strlen(filename)-3));
	    if (!strcasecmp(ext,"RIP")) { /* it's a rip, show it */
		showntype=tRip;
		parserip(myfile);
	    } else {
		ansofs=0;	/* otherwise it's an ansi/ascii */
		showntype=tAnsi;
		parseansi(myfile);
	    }
	    XStoreName(display,window,filename);
	    fclose(myfile);
	}
    }
    free(ext);
}

/* change filemask */
void ChangeMask(Widget w)
{
    char *maskname;
    Widget widget=XtParent(XtParent(w));
    XtVaGetValues(w,XtNlabel,&maskname,NULL);
    XtVaSetValues(widget,XtNlabel,maskname,NULL);
    strcpy(curmask,maskname);
    updatefiles();
    XawListChange(owlist,filelist,0,0,True);
}

int updatefiles()
{
    struct stat stats;
    DIR *dir;
    struct dirent *entry;
    int d,i,m;
    if (stat(curdir,&stats))
      return False;
    if (chdir(curdir))
      return False;
    if (!(dir=opendir(".")))
      return False;
    for (i=0;(entry=readdir(dir));i++) {
	if (lstat(entry->d_name,&stats))
	  goto error1;
	if (stats.st_mode & S_IFDIR) {
	    filelist=(char **)XtRealloc((char *)filelist,(i+1)*sizeof(char *));
	    filelist[i]=(char *)XtMalloc(255);
	    strcpy(filelist[i],entry->d_name);
	    strcat(filelist[i],"/");
	}
	else {
	    if (match(curmask,entry->d_name)) { /* my own regexp */
		filelist=(char **)XtRealloc((char *)filelist,
					    (i+1)*sizeof(char *));
		filelist[i]=(char *)XtMalloc(255);
		strcpy(filelist[i],entry->d_name);
	    } else
	      i--;
	}
    }
    filelist=(char **)XtRealloc((char *)filelist,(i+1)*sizeof(char *));
    filelist[i]=(char *) XtMalloc(255);
    filelist[i]=NULL;
    if (closedir(dir))
      goto error1;
    return True;
  error1:
    for (m=0;m<=i;m++)
      XtFree((char *)filelist[m]);
    XtFree((char *)filelist);
    return False;
}

/* my very own regex routine, handles ? and * for filenames.. */
Boolean match(char *p,char *s)
{
    while (1) {
	switch (*p) {
	  case '\0':
	    if (*s=='\0')
	      return TRUE;
	  case '?':
	    if (*s++=='\0')
	      return FALSE;
	    break;
	  case '*':
	    p++;
	    if (*p=='\0')
	      return TRUE;
	    while (1) {
		do {
		    if (*s=='\0')
		      return FALSE;
		} while (*s++!=*p);
		if (match(p,s-1)==TRUE)
		  break;
	    }
	    break;
	  default:
	    if (*s++!=*p)
	      return FALSE;
	}
	p++;
    }
}

/* 16 pixel font */
void appSet25()
{
    if (showntype==tAnsi) {
	ansMode=0;
	Redraw();
    }
}
/* 8 pixel font */
void appSet50()
{
    if (showntype==tAnsi) {
	ansMode=1;
	Redraw();
    }
}

