/***************************************************************************
 *                                                                         *
 * avX-gif.c                                                               *
 *                                                                         *
 * AcidView For X - gif parser                                             *
 * This isn't implemented yet...                                           *
 * Written by Sean Kasun                                                   *
 *                                                                         *
 * Copyright 1995-1998, ACiD Productions                                   *
 *                                                                         *
 ***************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include "avX.h"
#include "avX-gif.h"

/* header structure */
typedef struct {
    byte sig[6];
    word width,height;
    byte flags,background,aspect;
} gifHead;
/* image structure */
typedef struct {
    word left,top,width,height;
    byte flags;
} image;

int flags,temp;
byte c;
FILE *myfile;
byte *rawGIF,*pic8,*dataPtr;  /* pic8 is the bitmap when it's done decodin */
int iWidth,iHeight,misc,numCols,bitsPerPixel,bitMask,background,i;
int colorMapSize,block,fileSize;
char hasColorMap;

/* results returned */
char results[9][25]=
{
    "Ok",
    "Bad file",
    "Bad read",
    "Unexpected end",
    "Bad LZW code",
    "Bad first code",
    "Memory error",
    "Bad symbol size"
};

/* decodes the gif */
void handleGIF(char *filename)
{
    if ((myfile=fopen(filename,"rb"))==NULL) {
	printf("Couldn't open %s\n",filename);
	return;
    }
	/* get size of file */
    fseek(myfile,0L,2);
    fileSize=ftell(myfile);
    fseek(myfile,0L,0);
    if (!(dataPtr=rawGIF=(byte *) malloc(fileSize))) {
	printf("Out of memory!\n");
	return;
    }
    if (fread(dataPtr,fileSize,1,myfile)!=1) {
	printf("Error reading gif\n");
	return;
    }
	/* unpack the gif */
    temp=unpackGIF();

    if (temp!=0)
      printf("%s\n",results[temp]); /* debug codes */
    fclose(myfile);

	/* set the palette (pinfo) here */
	/* show the gif (pic8) here */
}

/* this nukes an extension we don't support.. such as comments */
void killExt()
{
    dataPtr++;
    while ((temp=*dataPtr++)>0 && (dataPtr-rawGIF)<fileSize)
      dataPtr+=temp;
}

/* unpacks the gif, decoding extensions etc.. decodes the first graphic
   info it finds */
int unpackGIF()
{
    char ch;

	/* is it a real gif? */
    if (strncmp((char *)dataPtr,"GIF",3)!=0)
      return 1;

    dataPtr+=6;	/* skip gif tag */
    dataPtr+=4; /* skip screen dimensions, they're not used */

    ch=*dataPtr++;  /* checks for global color map, as opposed to image */
    hasColorMap=((ch & 0x80) ? True : False);

    bitsPerPixel=(ch & 7)+1;  /* if there is a map, get the bit depth */
    numCols=colorMapSize=1 << bitsPerPixel;  /* and find the num colors */
    bitMask=colorMapSize-1;

    background=*dataPtr++;  /* get background color */

    dataPtr++;  /* skip aspect ratio */
    if (hasColorMap)   /* we have a global color map..read it just in case */
      for (i=0;i<colorMapSize;i++) {
	  pinfo->r[i]=*dataPtr++;
	  pinfo->g[i]=*dataPtr++;
	  pinfo->b[i]=*dataPtr++;
      }

   /* do the following until we die */
    while (1) {
	block=*dataPtr++;   /* get block type */
	if (block=='!')     /* extension we don't care about */
	  killExt();

	if (block==',') {   /* it's an image! */
	    dataPtr+=4;     /* skip image position, we'll put it at the top */
	    iWidth=*dataPtr++;  /* image width */
	    iWidth+=*dataPtr++*256; /* it's a word */
	    iHeight=*dataPtr++;  /* image height */
	    iHeight+=*dataPtr++*256; /* ditto baby */
	    misc=*dataPtr++;   /* local color map? */
	    if (misc & 0x80) {  /* yes indeed.. too lazy to use real vars */
		for (i=0;i<1<<((misc & 7)+1);i++) {
		    pinfo->r[i]=*dataPtr++;
		    pinfo->g[i]=*dataPtr++;
		    pinfo->b[i]=*dataPtr++;
		}
	    }
	    temp=*dataPtr++;   /* get bits */
	    temp=unpackImage(temp);  /* decode the image */
	    return(temp);  /* bail after finding first image.. */
	}
    }
    return(0);
}

/* lzw decompress image */
int unpackImage(int bits)
{
   /* this code is so standard, it's laughable */
   /* i've done a lot to this code over the years, so this is damn fast */
    int bits2,codeSize,codeSize2,nextCode,thisCode,oldToken,currentCode;
    int oldCode,bitsLeft,blockSize,line=0,byt=0,pass=0;
    byte *p,*q,b[255],*u,*lineBuffer;
    byte firstCodeStack[4096],lastCodeStack[4096];
    int codeStack[4096];
    int wordMaskTable[]={ /* simply (2^index)-1 */
	0x0000,0x0001,0x0003,0x0007,0x000f,0x001f,0x003f,0x007f,
	0x00ff,0x01ff,0x03ff,0x07ff,0x0fff,0x1fff,0x3fff,0x7fff
    };
    int incTable[]={8,8,4,2,0};  /* interlacing */
    int startTable[]={0,4,2,1,0};  /* yup */

    bitsLeft=8;			/* bits left in series */
    if (bits<2 || bits>8)	/* oop corrupt bit len */
      return 7;

    bits2=1<<bits;		/* 2^bit baby */
    nextCode=bits2+2;
    codeSize2=1<<(codeSize=bits+1);
    oldCode=oldToken=-1;

	/* loop until we die */
    for (;;) {
	if (bitsLeft==8) {
	    if ((++dataPtr-rawGIF)>fileSize)
	      return 3;
	    bitsLeft=0;
	}
	thisCode=*dataPtr;
	if ((currentCode=(codeSize+bitsLeft))<=8) {
	    *dataPtr>>=codeSize;
	    bitsLeft=currentCode;
	} else {
	    if ((++dataPtr-rawGIF)>fileSize)
	      return 3;
	    thisCode |= *dataPtr<<(8-bitsLeft);
	    if (currentCode<=16)
	      *dataPtr>>=(bitsLeft=currentCode-8);
	    else {
		if ((++dataPtr-rawGIF)>fileSize)
		  return 3;
		thisCode |= *dataPtr<<(16-bitsLeft);
		*dataPtr>>=(bitsLeft=currentCode-16);
	    }
	}
	thisCode &=wordMaskTable[codeSize];
	currentCode=thisCode;
	if (thisCode==(bits2+1))
	  break;
	if (thisCode>nextCode)
	  return 4;
	if (thisCode==bits2) {
	    nextCode=bits2+2;
	    codeSize2=1<<(codeSize=(bits+1));
	    oldToken=oldCode=-1;
	    continue;
	}
	u=firstCodeStack;
	if (thisCode==nextCode) {
	    if (oldCode==-1)
	      return 5;
	    *u++=oldToken;
	    thisCode=oldCode;
	}
	while (thisCode >= bits2) {
	    *u++=lastCodeStack[thisCode];
	    thisCode=codeStack[thisCode];
	}
	oldToken=thisCode;
	do {
	    pic8[(byt++)+line*iWidth]=thisCode;  /* save it */
	    if (byt>=iWidth) {
		byt=0;
		if (flags & 0x40) {
		    line+=incTable[pass];
		    if (line>=iHeight)
		      line=startTable[++pass];
		} else
		  line++;
	    }
	    if (u<=firstCodeStack)
	      break;
	    thisCode=*--u;
	} while (1);
	if (nextCode<4096 && oldCode!=-1) {
	    codeStack[nextCode]=oldCode;
	    lastCodeStack[nextCode]=oldToken;
	    if (++nextCode>=codeSize2 && codeSize<12)
	      codeSize2=1<<++codeSize;
	}
	oldCode=currentCode;
    }
    return 0;
}
	    
