/***************************************************************************
 *                                                                         *
 * avX-ansi.c                                                              *
 *                                                                         *
 * AcidView For X - ansi parser and display routines                       *
 * Written by Sean Kasun                                                   *
 *                                                                         *
 * Copyright 1995-1998, ACiD Productions                                   *
 *                                                                         *
 ***************************************************************************/


#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <stdio.h>
#include <stdlib.h>
#include "avX.h"
#include "avX-ansi.h"

/* our default palette */
int def2pal[16]={0,1,2,3,4,5,0x14,7,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f};
int colrx[16];
XColor colr;

byte colors[]={
    0,0x00,0x07,
    1,0xff,0x08,
    4,0xf8,0x01,
    5,0xff,0x80,
    7,0xf8,0x70,
    8,0x88,0x00,
    30,0xf8,0x00,
    31,0xf8,0x04,
    32,0xf8,0x02,
    33,0xf8,0x06,
    34,0xf8,0x01,
    35,0xf8,0x05,
    36,0xf8,0x03,
    37,0xf8,0x07,
    40,0x8f,0x00,
    41,0x8f,0x40,
    42,0x8f,0x20,
    43,0x8f,0x60,
    44,0x8f,0x10,
    45,0x8f,0x50,
    46,0x8f,0x30,
    47,0x8f,0x70,
    255
};

void (*process)(void);
void escapeCheck(void);
void bracketCheck(void);
void ansiDecode(void);
void showAnsi(void);

byte *ansbuf;
dword ansofs;
dword offset,saveOffset;	/* offset in ansi our cursor is */
long maxSize;			/* if we go over this, we realloc */
byte numItems;
word item[10];
word lines,width,height;
byte ch,attr;
GC myfgc,mybgc;
XGCValues gcvals;

int coltype=0;		/* color types */

char eolstr[80];	/* end of line clearing buffer */

/* Reads & Parses the ansi into the buffer ansbuf */
void parseansi(FILE *myfile)
{
	int i;
		
	for (i=0;i<80;i++)
		eolstr[i]=219;	/* solid fill */

	XClearWindow(display,window);

	if (mycmap!=0) {	/* clear the map */
		XFreeColormap(display,mycmap);
		mycmap=0;
	}
	/* create a new color map for ourselves */
	mycmap=XCreateColormap(display,window,
		 DefaultVisual(display,DefaultScreen(display)),
		 AllocNone);

	/* build our colors..
	   the colors are built exactly how BIOS does it in dos.
	   PALRANGE is the max color value.  In BIOS it's 255, but in
	   X11, it's 65535. */

#define PALRANGE 65535
#define MINSHADE PALRANGE/3
#define MEDSHADE MINSHADE*2

	for (i=0;i<16;i++) {
		colr.red=((def2pal[i]&32)/32)*MINSHADE;
		colr.red+=((def2pal[i]&4)/4)*MEDSHADE;
		colr.green=((def2pal[i]&16)/16)*MINSHADE;
		colr.green+=((def2pal[i]&2)/2)*MEDSHADE;
		colr.blue=((def2pal[i]&8)/8)*MINSHADE;
		colr.blue+=(def2pal[i]&1)*MEDSHADE;
		XAllocColor(display,mycmap,&colr);
		colrx[i]=colr.pixel;	/* save our index */
	}
	XSetWindowColormap(display,window,mycmap);

	attr=7;		/* default color is 7, aka grey on black */
	offset=saveOffset=0;  /* start at the top */
	lines=1;	/* one line so far */

	process=escapeCheck; /* start processing by looking for escapes */

	if (ansbuf!=NULL) {	/* old ansi to kill */
		free((void *)ansbuf);
		ansbuf=NULL;
	}

	/* start off small, we'll realloc later */
	maxSize=64000;
	if ((ansbuf=(byte *)malloc(maxSize))==NULL) {
		printf("Couldn't malloc 64k!\n");
		quit();
	}
	/* malloc doesn't zero out the buffer, so we'll set it to standard */
	for (i=0;i<maxSize/2;i++) {
		ansbuf[i*2]=32;
		ansbuf[i*2+1]=7;
	}

	/* go until end of file baby */
	while (!feof(myfile)) {
		ch=fgetc(myfile);
		if (ch==26)	/* end of file, sauce style */
			break;
		process();	/* processes the byte */

		/* are we out of bounds?  If so, realloc */
		if (offset>=maxSize) {
			maxSize*=2;
			ansbuf=(byte *)realloc((void *)ansbuf,maxSize);
			memset(&ansbuf[offset+1],0,(maxSize-offset)-1);
		}
	}
	lines=offset/160;	/* count # of lines in ansi */
	showansi();		/* display that bastard */
}

/* A better Idea: Break it up into a set of 16 "overlays" in which each
  color is laid down...first lay down background colors, then lay down
  16 foreground colors.  The current way is slow because of all the color
  changes */
void showansi()
{
	int oldback,oldfore,fore,back;	/* for changing colors */
	char *colrline;			/* a line of color */
	char colr[100];
	int sx,scx,sy,i,oldattr,maxy,chht;

	if (ansbuf==NULL)	/* no ansi! */
		return;

	sx=sy=scx=0;
	oldattr=7;
	colrline=colr;
	oldback=0;
	oldfore=7;	
		
	gcvals.font=dos25font;		/* 16 pixel high font */
	chht=16;			/* char height */
	if (ansMode==1) {		/* we really want 8 pixel font */
		chht=8;
		gcvals.font=dos50font;
	}

	/* look what it takes to set the damn color */
	gcvals.foreground=colrx[7];	/* set foreground */
	myfgc=XCreateGC(display,window,(GCFont|GCForeground),&gcvals);
	gcvals.foreground=colrx[0];	/* set background */
	mybgc=XCreateGC(display,window,(GCFont|GCForeground),&gcvals);

	maxy=height/chht;	/* max Y to draw */
	if (maxy>lines)		/* ansi is smaller than window size */
		maxy=lines;

	/* currently we queue up a line of same-color text, and then output
	   it, this changes how often we change colors. */
	while (sy<maxy) {	/* go until we reach bottom of window */
		/* changed color, or reached end of line */
		if (ansbuf[(sy+ansofs)*160+sx*2+1]!=oldattr || sx==80) {
			/* looks like we have a whole line of text to output */
			if (sx-scx>0) {
				*colrline=0;
				if (coltype==0) {	/* color baby */
					back=(oldattr/16)&15;
					fore=oldattr&15;
					if (back!=oldback) {
						gcvals.foreground=colrx[back];
						XChangeGC(display,mybgc,(GCForeground),&gcvals);
						oldback=back;
					}
					/* first we set the background color */
					XDrawString(display,window,mybgc,
						scx*8,(sy+1)*chht,eolstr,sx-scx);
					if (fore!=oldfore) {
						gcvals.foreground=colrx[fore];
						XChangeGC(display,myfgc,(GCForeground),&gcvals);
						oldfore=fore;
					}
					/* then we set the forground color */
					XDrawString(display,window,myfgc,
						scx*8,(sy+1)*chht,colr,sx-scx);
				}
				if (coltype==2) {   /* ascii mode */
					XDrawString(display,window,mybgc,
						scx*8,(sy+1)*chht,eolstr,sx-scx);
					XDrawString(display,window,myfgc,
						scx*8,(sy+1)*chht,colr,sx-scx);
				}
				colrline=colr;
				scx=sx;
			}
			if (sx==80) {
				sx=scx=0;
				sy++;
			}
			oldattr=ansbuf[(sy+ansofs)*160+sx*2+1];
		}
		*colrline++=ansbuf[(sy+ansofs)*160+sx*2];
		sx++;
	}
	XFreeGC(display,myfgc);	/* free colors */
	XFreeGC(display,mybgc);
}

/* this routine checks for escapes in the input stream */
void escapeCheck()
{
	if (ch==27)	/* found one! now look for brackets */
		process=bracketCheck;
	else {
		if (ch==10 || ch==13) {	/* found a return */
			offset=(offset/160)*160;	/* X=0 */
			if (ch==10)
				offset+=160;		/* Y++ */
		} else {
			ansbuf[offset]=ch;	/* otherwise store char */
			ansbuf[offset+1]=attr;
			offset+=2;
		}
	}
}

/* search for brackets in input string.. */
void bracketCheck()
{
	if (ch=='[') {		/* got a bracket! that means ansi code */
		item[0]=numItems=0;  /* clear ansi code array */
		process=ansiDecode;
	} else {
		ansbuf[offset]=27;	/* no bracket, print the escape and */
		ansbuf[offset+2]=ch;	/* the current char */
		ansbuf[offset+1]=ansbuf[offset+3]=attr;
		offset+=4;
	}
}

/* found an escape and a bracket, now decode the ansi code */
void ansiDecode()
{
	int i,j;
	byte ctl;
	if (ch>='0' && ch<='9') {	/* a # gets stored as a param */
		item[numItems]*=10;	/* advance old item */
		item[numItems]+=(ch-'0'); /* store number */
		return;
	}
	if (ch=='?') {
		item[numItems]*=10;	/* store ? as a zero */
		return;
	}
	if (ch==';') {
		numItems++;		/* next number */
		item[numItems]=0;
		return;
	}
	if (ch>='A' && ch<='D')		/* move of 0 means 1 */
		if (item[0]==0)
			item[0]++;	/* make 0 into 1 */

	switch (ch) {
		case 'A':		/* move up */
			offset-=160*item[0];
			if (offset<0)	/* hit roof? */
				offset=0;
			break;
		case 'B':		/* move down */
			offset+=160*item[0];
			break;
		case 'C':		/* move right */
			offset+=item[0]*2;
			break;
		case 'D':		/* move left */
			offset-=item[0]*2;
			if (offset<0)	/* hit roof? */
				offset=0;
			break;
		case 'H':		/* move to */
		case 'f':
			offset=((item[0]-1)*80+(item[1]-1))*2;
			break;
		case 's':
			saveOffset=offset;	/* save x,y */
			break;
		case 'u':
			offset=saveOffset;	/* restore x,y */
			break;
		case 'J':		/* clear screen not impl */
			break;
		case 'K':		/* clear eol */
			for (i=offset%160;i<1600;i+=2) {
				ansbuf[offset+i]=' ';
				ansbuf[offset+i+1]=attr;
			}
			break;
		case 'm':		/* set color */
			for (i=0;i<=numItems;i++) {
				j=0;
				while ((ctl=colors[j])!=255) {
					if (ctl==item[i]) {
						attr&=colors[j+1];
						attr|=colors[j+2];
					}
					j+=3;
	    			}
			}
			break;
		default:		/* ignore bad codes */
    	}
	process=escapeCheck;		/* go find escapes again */
}







