Unit AF_PMods;     { Loader/Demo programmer information }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
 5|                                       Years Modding : [...]
 6|                       Number of mods done (approx.) : [....]
 7|     How much time does it take you to mod something : [......................]
 8|          How often can you produce a mod for ACiDiC : [......................]
 9|    What BBS Softwares can you mod (OBV/2, PCB, etc) : [......................]
10|
11|Describe some BBS modifications you have done in the past :
12|[.............................................................................]
13|[.............................................................................]
14|[.............................................................................]
15|
16|What kind of modifications can you develop/wish to develop under ACiDiC :
17|[.............................................................................]
18|[.............................................................................]
19|[.............................................................................]
20|
21|Additional Comments :
22|[.............................................................................]
23|[.............................................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE  FormType = RECORD
                Years      : PictureIOOBJ;
                TotMods    : PictureIOOBJ;
                Time       : LateralIOOBJ;
                HowOften   : LateralIOOBJ;
                BBSTypes   : LateralIOOBJ;
                PrevMods1  : LateralIOOBJ;
                PrevMods2  : LateralIOOBJ;
                PrevMods3  : LateralIOOBJ;
                ModType1   : LateralIOOBJ;
                ModType2   : LateralIOOBJ;
                ModType3   : LateralIOOBJ;
                Comments1  : LateralIOOBJ;
                Comments2  : LateralIOOBJ;
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_MODS.OBJ}
PROCEDURE APP_MODS; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_MODS, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Years);
     AddItem(Form^.TotMods);
     AddItem(Form^.Time);
     AddItem(Form^.HowOften);
     AddItem(Form^.BBSTypes);
     AddItem(Form^.PrevMods1);
     AddItem(Form^.PrevMods2);
     AddItem(Form^.PrevMods3);
     AddItem(Form^.ModType1);
     AddItem(Form^.ModType2);
     AddItem(Form^.ModType3);
     AddItem(Form^.Comments1);
     AddItem(Form^.Comments2);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_MODS^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,----------------------.');
    Writeln(Out, ',-'' ACiDiC Application  `--------------------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Years Modding               : ', Years.GetValue);
    Writeln(Out, 'Number of mods done?        : ', TotMods.GetValue);
    Writeln(Out, 'How much time does it take to mod something? : ', Time.GetValue);
    Writeln(Out, 'How often can you produce a mod for ACiDiC?  : ', HowOften.GetValue);
    Writeln(Out, 'What BBS software can you mod? : ', BBSTypes.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Describe some BBS Modifications you have done in the past:');
    Writeln(Out, PrevMods1.GetValue);
    Writeln(Out, PrevMods2.GetValue);
    Writeln(Out, PrevMods3.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What kind of modifications can you develop/wish to develop under ACiDiC?');
    Writeln(Out, ModType1.GetValue);
    Writeln(Out, ModType2.GetValue);
    Writeln(Out, ModType3.GetValue);
    WRiteln(Out, '');
    Writeln(Out, 'Additional Comments:');
    Writeln(Out, Comments1.GetValue);
    Writeln(Out, Comments2.GetValue);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Years.Done;
     TotMods.Done;
     Time.Done;
     HowOften.Done;
     BbsTypes.Done;
     PrevMods1.Done;
     PrevMods2.Done;
     PrevMods3.Done;
     ModType1.Done;
     ModType2.Done;
     ModType3.Done;
     Comments1.Done;
     Comments2.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Years.Init(57, 5, '###');
     Years.SetPadChar('.');

     TotMods.Init(57, 6, '####');
     TotMods.SetPadChar('.');

     Time.Init(57, 7, 22, 50);
     Time.SetPadChar('.');

     HowOften.Init(57, 8, 22, 50);
     HowOften.SetPadChar('.');

     BBSTypes.Init(57, 9, 22, 50);
     BBSTypes.SetPadChar('.');

     PrevMods1.Init(2, 12, 77, 77);
     PrevMods1.SetPadChar('.');

     PrevMods2.Init(2, 13, 77, 77);
     PrevMods2.SetPadChar('.');

     PrevMods3.Init(2, 14, 77, 77);
     PrevMods3.SetPadChar('.');

     ModType1.Init(2, 17, 77, 77);
     ModType1.SetPadChar('.');

     ModType2.Init(2, 18, 77, 77);
     ModType2.SetPadChar('.');

     ModType3.Init(2, 19, 77, 77);
     ModType3.SetPadChar('.');

     Comments1.Init(2, 22, 77, 77);
     Comments1.SetPadChar('.');

     Comments2.Init(2, 23, 77, 77);
     Comments2.SetPadChar('.');

  END;
END.
