Unit AF_PApps;     { Applications/Utilities programmer information }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
 5|                                        Years Coding : [...]
 6|               Number of programs produced (approx.) : [....]
 7|    How much time does it take you to code something : [......................]
 8|   How often can you produce an app or util for ACiD : [......................]
 9|    What OS's can you code under (DOS, Windows, etc) : [......................]
10|
11|What programming languages are you fluent in :
12|[.............................................................................]
13|[.............................................................................]
14|
15|What kind of programs can you develop/wish to develop under ACiD :
16|[.............................................................................]
17|[.............................................................................]
18|[.............................................................................]
19|
20|Additional Comments :
21|[.............................................................................]
22|[.............................................................................]
23|[.............................................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE  FormType = RECORD
                Years      : PictureIOOBJ;
                TotPrograms: PictureIOOBJ;
                Time       : LateralIOOBJ;
                HowOften   : LateralIOOBJ;
                OS         : LateralIOOBJ;
                Languages1 : LateralIOOBJ;
                Languages2 : LateralIOOBJ;
                AppType1   : LateralIOOBJ;
                AppType2   : LateralIOOBJ;
                AppType3   : LateralIOOBJ;
                Comments1  : LateralIOOBJ;
                Comments2  : LateralIOOBJ;
                Comments3  : LateralIOOBJ;
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_APPS.OBJ}
PROCEDURE APP_APPS; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_APPS, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Years);
     AddItem(Form^.TotPrograms);
     AddItem(Form^.Time);
     AddItem(Form^.HowOften);
     AddItem(Form^.OS);
     AddItem(Form^.Languages1);
     AddItem(Form^.Languages2);
     AddItem(Form^.AppType1);
     AddItem(Form^.AppType2);
     AddItem(Form^.AppType3);
     AddItem(Form^.Comments1);
     AddItem(Form^.Comments2);
     AddItem(Form^.Comments3);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_APPS^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,-------------------------------.');
    Writeln(Out, ',-'' Apps/Utils Coder Application  `-----------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Years Coding                : ', Years.GetValue);
    Writeln(Out, 'Number of programs produced : ', TotPrograms.GetValue);
    Writeln(Out, 'How much time does it take to code a utility?     : ', Time.GetValue);
    Writeln(Out, 'How many programs can you produce in one month?   : ', HowOften.GetValue);
    Writeln(Out, 'What OS''s do you code utilities for?       : ', OS.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What programming languages are you fluent in?');
    Writeln(Out, Languages1.GetValue);
    Writeln(Out, Languages2.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'What kind of programs do you wish to code for ACiD?:');
    Writeln(Out, AppType1.GetValue);
    Writeln(Out, AppType2.GetValue);
    Writeln(Out, AppType3.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Additional Comments:');
    Writeln(Out, Comments1.GetValue);
    Writeln(Out, Comments2.GetValue);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Years.Done;
     TotPrograms.Done;
     Time.Done;
     HowOften.Done;
     OS.Done;
     Languages1.Done;
     Languages2.Done;
     AppType1.Done;
     AppType2.Done;
     AppType3.Done;
     Comments1.Done;
     Comments2.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Years.Init(57, 5, '###');
     Years.SetPadChar('.');

     TotPrograms.Init(57, 6, '####');
     TotPrograms.SetPadChar('.');

     Time.Init(57, 7, 22, 50);
     Time.SetPadChar('.');

     HowOften.Init(57, 8, 22, 50);
     HowOften.SetPadChar('.');

     OS.Init(57, 9, 22, 50);
     OS.SetPadChar('.');

     Languages1.Init(2, 12, 77, 77);
     Languages1.SetPadChar('.');

     Languages2.Init(2, 13, 77, 77);
     Languages2.SetPadChar('.');

     AppType1.Init(2, 16, 77, 77);
     AppType1.SetPadChar('.');

     AppType2.Init(2, 17, 77, 77);
     AppType2.SetPadChar('.');

     AppType3.Init(2, 18, 77, 77);
     AppType3.SetPadChar('.');

     Comments1.Init(2, 21, 77, 77);
     Comments1.SetPadChar('.');

     Comments2.Init(2, 22, 77, 77);
     Comments2.SetPadChar('.');

     Comments3.Init(2, 23, 77, 77);
     Comments3.SetPadChar('.');
  END;
END.
