Unit AF_MUSIC;     { Musicician information }

{--------------------------------------------------------------------------------}
INTERFACE
{--------------------------------------------------------------------------------}

{           1         2         3         4         5         6         7         8
   12345678901234567890123456789012345678901234567890123456789012345678901234567890
 5|                                Years tracking music : [...]
 6|                            Number of songs composed : [....]
 7| How long is your largest tune, in minutes (approx.) : [....]
 8|      How long does it take you to complete one song : [......................]
 9|      How many songs can you compose for ACiD/pHluid : [....]
10|                           Favorite tracking program : [......................]
11|
12|Preferred music style :
13|[.............................................................................]
14|
15|Favorite computer musicians :
16|[.............................................................................]
17|
18|What would you consider your strongest/weakest points :
19|[.............................................................................]
20|
21|Additional Comments :
22|[.............................................................................]
23|[.............................................................................]
}

FUNCTION  Entry(Page, NumPages, Direction : Integer) : Integer;
PROCEDURE Store(VAR Out: Text);

{--------------------------------------------------------------------------------}
IMPLEMENTATION
{--------------------------------------------------------------------------------}

USES  CRTVGA,
      Support,
      TOTFast, TOTIO1, TOTIO2, TOTIO3, TOTInput, TOTStr;

TYPE   FormType = RECORD
                Years      : PictureIOOBJ;
                TotSongs   : PictureIOOBJ;
                LargestSong: PictureIOOBJ;
                Time       : LateralIOOBJ;
                MonthSong  : PictureIOOBJ;
                Tracker    : LateralIOOBJ;
                FavStyle   : LateralIOOBJ;
                FavArtists : LateralIOOBJ;
                StrongWeak  : LateralIOOBJ;
                Comments1  : LateralIOOBJ;
                Comments2  : LateralIOOBJ;
              END;
VAR   Form         : ^FormType;
      SaveExitProc : POINTER;



{$L APP_MUSIC.OBJ}
PROCEDURE APP_MUSIC; External;


FUNCTION Entry(Page, NumPages, Direction : Integer) : Integer;
VAR   Manager     : FormOBJ;
      Result      : tAction;
      UpKey,
      DownKey,
      TabKey,
      ShiftTabKey,
      EnterKey,
      PgDnKey,
      PgUpKey,
      F10Key      : HotKeyIOOBJ;

BEGIN
  { Initialize (construct) Objects Entry }
  Manager.Init;
  UpKey.Init      (KEY_Up,      PrevField);
  DownKey.Init    (KEY_Down,    NextField);
  EnterKey.Init   (KEY_Enter,   NextField);
  TabKey.Init     (KEY_Tab,     NextField);
  ShiftTabKey.Init(KEY_ShiftTab,PrevField);
  PgUpKey.Init    (KEY_PgUp,    Stop1);
  PgDnKey.Init    (KEY_PgDn,    Stop2);
  F10Key.Init     (KEY_F10,     Stop3);

  { Show Form Screen }
  SlideForm(@APP_MUSIC, Page, NumPages, Direction);

  WITH Manager DO BEGIN
     { Add special keys }
     AddItem(UpKey);
     AddItem(DownKey);
     AddItem(EnterKey);
     AddItem(TabKey);
     AddItem(ShiftTabKey);
     IF (Page>1) THEN
        AddItem(PgUpKey);
     IF (Page<NumPages) THEN
        AddItem(PgDnKey);
     IF (Page=NumPages) THEN
        AddItem(F10Key);
     { Input items }
     AddItem(Form^.Years);
     AddItem(Form^.TotSongs);
     AddItem(Form^.LargestSong);
     AddItem(Form^.Time);
     AddItem(Form^.MonthSong);
     AddItem(Form^.Tracker);
     AddItem(Form^.FavStyle);
     AddItem(Form^.FavArtists);
     AddItem(Form^.StrongWeak);
     AddItem(Form^.Comments1);
     AddItem(Form^.Comments2);
  END;

  { Do entry }
  Screen.CursOn;                      { Cursor on }
  IoTot^.SetColField(8, 15, 7, 8);    { Set color for fields. (Inactive field, Active field, Picture (non editable), Readonly }
  Result := Manager.Go;

  { What to do next }
  Case Result of
     Escaped : Entry:=0;
     Stop1   : Entry:=-1;
     Stop2   : Entry:=1;
     Stop3   : Entry:=10;
  END;

  { Dispose (destruct) objects }
  Manager.Done;
  UpKey.Done;
  DownKey.Done;
  EnterKey.Done;
  TabKey.Done;
  ShiftTabKey.Done;
  PgUpKey.Done;
  PgDnKey.Done;
  F10Key.Done;

  { Dirty trick.  Move on screen data back into linked screen.  This makes }
  { paging back to it look better                                          }
  Move(VGA_Memory, @APP_MUSIC^, 4000);
END;


PROCEDURE Store(VAR Out: Text);
BEGIN
  WITH Form^ DO BEGIN
    Writeln(Out, '  ,----------------------.');
    Writeln(Out, ',-'' Musician Application `--------------------------------------------------.');
    Writeln(Out, '|                                                                           |');
    Writeln(Out, '`---------------------------------------------------------------------------''');
    Writeln(Out, '');
    Writeln(Out, 'Years tracking music      : ', Years.GetValue);
    Writeln(Out, 'Number of songs composed  : ', TotSongs.GetValue);
    Writeln(Out, 'How long is your largest tune, in minutes (approx.) : ', LargestSong.GetValue);
    Writeln(Out, 'How long does it take you to complete one song?     : ', Time.GetValue);
    Writeln(Out, 'How many songs can you compose for ACiD/pHluid      : ', MonthSong.GetValue);
    Writeln(Out, 'What is your favorite tracking program? : ', Tracker.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Preferred music style :');
    Writeln(Out, FavStyle.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Favorite computer musicians :');
    Writeln(Out, FavArtists.GetValue);
    WRiteln(Out, '');
    Writeln(Out, 'What would you consider your strongest/weakest points :');
    Writeln(Out, StrongWeak.GetValue);
    Writeln(Out, '');
    Writeln(Out, 'Additional Comments:');
    Writeln(Out, Comments1.GetValue);
    Writeln(Out, Comments2.GetValue);
    Writeln(Out, '');
  END;
END;


{$F+} { Exitproc must be "far" }
PROCEDURE Cleanup;
BEGIN
  { Dispose (destruct) objects }
  WITH Form^ DO BEGIN
     Years.Done;
     TotSongs.Done;
     LargestSong.Done;
     Time.Done;
     MonthSong.Done;
     Tracker.Done;
     FavStyle.Done;
     FavArtists.Done;
     StrongWeak.Done;
     Comments1.Done;
     Comments2.Done;
  END;

  Dispose(Form);

  { And revert to original ExitProc }
  ExitProc:=SaveExitProc;
END;
{$F-}


BEGIN
  New(Form);
  FillChar(Form^, sizeof(Form^), 0);

  { Install cleanup routine }
  SaveExitProc:= ExitProc;
  ExitProc:=@Cleanup;

  { One time initialization of Form }
  WITH Form^ DO BEGIN
     Years.Init(57, 5, '###');
     Years.SetPadChar('.');

     TotSongs.Init(57, 6, '####');
     TotSongs.SetPadChar('.');

     LargestSong.Init(57, 7, '####');
     LargestSong.SetPadChar('.');

     Time.Init(57, 8, 22, 50);
     Time.SetPadChar('.');

     MonthSong.Init(57, 9, '####');
     MonthSong.SetPadChar('.');

     Tracker.Init(57, 10, 22, 50);
     Tracker.SetPadChar('.');

     FavStyle.Init(2, 13, 77, 77);
     FavStyle.SetPadChar('.');

     FavArtists.Init(2, 16, 77, 77);
     FavArtists.SetPadChar('.');

     StrongWeak.Init(2, 19, 77, 77);
     StrongWeak.SetPadChar('.');

     Comments1.Init(2, 22, 77, 77);
     Comments1.SetPadChar('.');

     Comments2.Init(2, 23, 77, 77);
     Comments2.SetPadChar('.');
  END;
END.
