.model large
.stack 256            ; allocate 256 bytes for the stack
.286                  ; must use cuz insb and outsb is 286 or higher code
dosseg

picture segment byte public 'FARDATA'
include vesa.inc
picture ends

.data                 ; start of the data segment
.code                 ; start of code segment
sorry  DB 'Sorry, but this demo requires a VESA Super VGA Card!',13,'$' ;message for non VGA lamers
vesabuf DB 262 dup (0)    ; must have 262 byte buffer for vesa info
fadepalette DB 768 dup (0)
text DB  ' This SVGA is released with 100% ASM source code April 1994 ACiD Acquisition',13,10
     DB  ' Code by: Rocket Scientist <ACiD> SVGA Graphics by: Renderman <ACiD wannabe>',13,'$'
start   proc  far            ; far for large model
        mov     ax,cs        ; move cs to ax
        mov     ds,ax        ; move cs to ds
        mov     es,ax        ; move cs to es
        mov     di,OFFSET vesabuf
        mov     ax,4F00h     ; set up for vesa check
        int     10h          ; do it
        cmp     ax,004Fh     ; gottem vesa card?
        je      vgaok        ; if so, run demo
        xor     ax,ax        ; clear ax
        mov     dx,offset sorry   ; if not, set up for message
        mov     ah,9         ; set up to print string
        int     21h          ; do it
        mov     ah,4ch       ; set up for exit
        int     21h          ; back to dos you lamer
vgaok:  mov     ax,4f02h     ; set vesa to mode 640X480X256
        mov     bx,101h
        int     10h          ; do it
        mov     ax,cs        ; move cs to ax
        mov     ds,ax        ; move cs to ds
        mov     si, offset fadepalette
        mov     dx,03c8h     ; go to PEL address register
        xor     al,al        ; set al to zero
        out     dx,al        ; output byte so we are at first byte
        inc     dx           ; go up to PEL data register
        mov     cx,3         ; loop three times
fupr4:  push    cx           ; save for later
        mov     cx,256       ; move 256 bytes (one third of palette)
        push    dx           ; save dx
        mov     dx,03dah     ; check for retrace
fupr5:  in      al,dx        ; input byte
        test    al,08h       ; test Vsync bit
        jz      fupr5
fupr6:  in      al,dx        ; point to status indicator
        test    al,08h       ; input byte, test Vsync bit
        jnz     fupr6        ; wait until not writing to screen
        pop     dx           ; restore dx to PEL data register
        rep     outsb        ; output to port 256 bytes of data
        pop     cx
        loop    fupr4        ; go do it three times for entire palette

        mov     ax,seg picture    ; move ax to data segment
        mov     ds,ax        ; move data segment to ds
        mov     ax,0a000h
        mov     es,ax        ; point ex to start of video memory
        mov     di,0         ; be sure di is at the start
        mov     si,OFFSET image ; move si to the offset of the image
        mov     cx,32000
        rep     movsw        ; moves 64000 bytes of picture to the screen
        call    fadeup
        mov     ah,0
        int     16h
        mov     ah,1         ; somebody hit a key?
        int     16h
        mov     ax,3         ; must go to text mode twice for some cards
        int     10h
        mov     ax,3
        int     10h
        mov     ah,9         ;put end-text
        mov     dx,offset text
        int     21h
        mov     ax,4c00h       ; set up for exit
        int     21h          ; back to dos you lamer
start   endp

fadeup  PROC
        mov     ax,seg picture    ; move cs to ax
        mov     es,ax        ; move cs to es
        mov     di,offset palette  ; load ES:DI to grey palette address
        mov     ax,cs        ; move cs to ax
        mov     ds,ax        ; move cs to ds
        mov     cx,63        ; set loop for 63 times
fup1:   push    cx           ; save for later
        xor     bx,bx        ; reset bx to 0
        mov     cx,768       ; set up for entire palette 768 bytes
fup2:   mov     al,es:[di+bx] ; move to first value
        cmp     al,Byte Ptr fadepalette[bx] ; compare palette to fadepalette
        je      fup3         ; if equal don't increment
        inc     Byte Ptr fadepalette[bx]  ;increment if not equal
fup3:   inc     bx           ; bump it up to next value
        loop    fup2         ; do it for all 768 bytes
        mov     dx,03c8h     ; go to PEL address register
        xor     al,al        ; setup write to zero
        out     dx,al        ; output byte
        inc     dx           ; move up to PEL data register
        mov     si, offset fadepalette  ; set DS:SI point to fadepalette
        mov     cx,3         ; set up for three loops
fup4:   push    cx           ; save for later
        mov     cx,256       ; get ready to move 256 bytes
        push    dx           ; save dx
        mov     dx,03dah     ; point to status indicator for retrace check
fup5:   in      al,dx        ; input byte
        test    al,08h       ; test Vsync bit
        jz      fup5
fup6:   in      al,dx        ; Point to status indicator
        test    al,08h       ; input byte
        jnz     fup6         ; test Vsync bit
        pop     dx           ; restore dx
        rep     outsb        ; output to port 256 bytes of data
        pop     cx
        loop    fup4         ; do the loop 3 times
        pop     cx           ; reload loop variable
        loop    fup1         ; do loop 63 times for 63 levels of intensity
        ret                  ; go back to calling procedure
fadeup  ENDP
        END start
